/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.anhtd081095.util;

import io.gitlab.anhtd081095.util.GeoPoint;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.lucene.util.SloppyMath;

public class GeoUtil {
    public static <T> T nearestPoint(List<T> lstData, double dLat, double dlng, GeoPoint<T> geoPoint) {
        Validate.notEmpty(lstData, (String)"List data is not empty", (Object[])new Object[0]);
        return lstData.stream().min((o1, o2) -> {
            Pair<Double, Double> p1 = geoPoint.latLng(o1);
            Pair<Double, Double> p2 = geoPoint.latLng(o2);
            double key1 = SloppyMath.haversinSortKey((double)dLat, (double)dlng, (double)((Double)p1.getLeft()), (double)((Double)p1.getRight()));
            double key2 = SloppyMath.haversinSortKey((double)dLat, (double)dlng, (double)((Double)p2.getLeft()), (double)((Double)p2.getRight()));
            return Double.compare(key1, key2);
        }).orElse(null);
    }

    public static <T> List<T> nearestPoint(List<T> lstData, double dLat, double dLng, GeoPoint<T> geoPoint, int limit) {
        Validate.notEmpty(lstData, (String)"List data is not empty", (Object[])new Object[0]);
        return lstData.stream().sorted((o1, o2) -> {
            Pair<Double, Double> p1 = geoPoint.latLng(o1);
            Pair<Double, Double> p2 = geoPoint.latLng(o2);
            double key1 = SloppyMath.haversinSortKey((double)dLat, (double)dLng, (double)((Double)p1.getLeft()), (double)((Double)p1.getRight()));
            double key2 = SloppyMath.haversinSortKey((double)dLat, (double)dLng, (double)((Double)p2.getLeft()), (double)((Double)p2.getRight()));
            return Double.compare(key1, key2);
        }).limit(limit).collect(Collectors.toList());
    }
}

