/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.anhtd081095.util;

import javax.servlet.http.HttpServletRequest;

public class HttpServletRequestUtil {
    public static String getClientIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getClientOS(HttpServletRequest request) {
        String browserDetails = request.getHeader("User-Agent");
        String lowerCaseBrowser = browserDetails.toLowerCase();
        if (lowerCaseBrowser.contains("windows")) {
            return "Windows";
        }
        if (lowerCaseBrowser.contains("mac")) {
            return "Mac";
        }
        if (lowerCaseBrowser.contains("x11")) {
            return "Unix";
        }
        if (lowerCaseBrowser.contains("android")) {
            return "Android";
        }
        if (lowerCaseBrowser.contains("iphone")) {
            return "IPhone";
        }
        return "UnKnown, More-Info: " + browserDetails;
    }

    public static String getClientBrowser(HttpServletRequest request) {
        String browserDetails = request.getHeader("User-Agent");
        String user = browserDetails.toLowerCase();
        Object browser = "";
        if (user.contains("msie")) {
            String substring = browserDetails.substring(browserDetails.indexOf("MSIE")).split(";")[0];
            browser = substring.split(" ")[0].replace("MSIE", "IE") + "-" + substring.split(" ")[1];
        } else if (user.contains("safari") && user.contains("version")) {
            browser = browserDetails.substring(browserDetails.indexOf("Safari")).split(" ")[0].split("/")[0] + "-" + browserDetails.substring(browserDetails.indexOf("Version")).split(" ")[0].split("/")[1];
        } else if (user.contains("opr") || user.contains("opera")) {
            if (user.contains("opera")) {
                browser = browserDetails.substring(browserDetails.indexOf("Opera")).split(" ")[0].split("/")[0] + "-" + browserDetails.substring(browserDetails.indexOf("Version")).split(" ")[0].split("/")[1];
            } else if (user.contains("opr")) {
                browser = browserDetails.substring(browserDetails.indexOf("OPR")).split(" ")[0].replace("/", "-").replace("OPR", "Opera");
            }
        } else {
            browser = user.contains("chrome") ? browserDetails.substring(browserDetails.indexOf("Chrome")).split(" ")[0].replace("/", "-") : (user.contains("mozilla/7.0") || user.contains("netscape6") || user.contains("mozilla/4.7") || user.contains("mozilla/4.78") || user.contains("mozilla/4.08") || user.contains("mozilla/3") ? "Netscape-?" : (user.contains("firefox") ? browserDetails.substring(browserDetails.indexOf("Firefox")).split(" ")[0].replace("/", "-") : (user.contains("rv") ? "IE" : "UnKnown, More-Info: " + browserDetails)));
        }
        return browser;
    }
}

