/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.anhtd081095.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import io.gitlab.anhtd081095.util.DateUtil;
import io.gitlab.anhtd081095.util.Singleton;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.format.annotation.DateTimeFormat;

public class DataUtil {
    private static final Logger log = LogManager.getLogger(DataUtil.class);
    public static final String PHONE_NUMBER_PATTERN = "^(([03+[2-9]|05+[6|8|9]|07+[0|6|7|8|9]|08+[1-9]|09+[1-4|6-9]]){3})+[0-9]{7}$";
    public static final String EMAIL_PATTERN = "[A-Z0-9a-z._%+-]+@([A-Za-z0-9-]+\\.)+[A-Za-z]+";
    public static final String IMAGE_EXTENSION_PATTERN = "^(gif|jpe?g|tiff?|png|webp|bmp)$";
    public static final String REGEX_BASE64 = "^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$";
    public static final String REGEX_FILE_NAME = "^.+\\.[A-Za-z]+$";
    public static final String REGEX_CRON_EXPRESSION = "^((\\*|\\?|\\d+((\\/|\\-|\\,){0,1}(\\d+))*)\\s*){6}$";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_FORMAT2 = "yyyy-MM-dd HH:mm";
    public static final String DATE_FORMAT3 = "yyyyMMdd";
    public static final String DATE_FORMAT4 = "dd/MM/yyyy HH:mm";
    public static final String DATE_FORMAT5 = "dd/MM";
    public static final String DATE_FORMAT6 = "EEEE, dd/MM/yyyy";
    public static final String DATE_FORMAT7 = "dd/MM/yyyy";
    private static final Random random = new Random();

    public static List<Field> getAllFields(Class<?> type) {
        Field[] declaredFields = type.getDeclaredFields();
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(declaredFields));
        Class<?> superClass = type.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            fields.addAll(DataUtil.getAllFields(superClass));
        }
        return fields;
    }

    public static String toUrlEncoded(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> mapEncode = new HashMap<String, Object>();
        List<Field> fields = DataUtil.getAllFields(obj.getClass());
        for (Field field : fields) {
            field.setAccessible(true);
            AtomicReference<String> datePattern = new AtomicReference<String>("");
            Annotation[] declaredAnnotations = field.getDeclaredAnnotations();
            if (declaredAnnotations.length > 0) {
                Arrays.stream(declaredAnnotations).forEach(annotation -> {
                    if (annotation instanceof DateTimeFormat) {
                        datePattern.set(((DateTimeFormat)annotation).pattern());
                    }
                });
            }
            String key = field.getName();
            Object value = field.get(obj);
            if (DataUtil.isNullOrEmpty(datePattern.get())) {
                mapEncode.put(key, value);
                continue;
            }
            map.put(key, DateUtil.dateToString((Date)value, datePattern.get()));
        }
        String url = DataUtil.toUrlEncoded(map, false);
        String urlEncoded = DataUtil.toUrlEncoded(mapEncode);
        return url + urlEncoded;
    }

    public static String toUrlEncoded(Map<String, Object> map) {
        return DataUtil.toUrlEncoded(map, true);
    }

    public static String toUrlEncoded(Map<String, Object> map, Boolean isEncode) {
        StringBuilder result = new StringBuilder();
        map.forEach((key, value) -> {
            if (value instanceof List) {
                ((List)value).forEach(item -> {
                    result.append(URLEncoder.encode(key, StandardCharsets.UTF_8)).append("=").append(isEncode != false ? URLEncoder.encode(DataUtil.safeToString(item), StandardCharsets.UTF_8) : DataUtil.safeToString(item));
                    result.append("&");
                });
            } else {
                result.append(URLEncoder.encode(key, StandardCharsets.UTF_8)).append("=").append(isEncode != false ? URLEncoder.encode(DataUtil.safeToString(value), StandardCharsets.UTF_8) : DataUtil.safeToString(value));
            }
            result.append("&");
        });
        return result.toString();
    }

    public static String toUrlEncoded(String value) {
        return URLEncoder.encode(DataUtil.safeToString(value), StandardCharsets.UTF_8);
    }

    public static String toUrl(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> mapEncode = new HashMap<String, Object>();
        List<Field> fields = DataUtil.getAllFields(obj.getClass());
        for (Field field : fields) {
            field.setAccessible(true);
            AtomicReference<String> datePattern = new AtomicReference<String>("");
            Annotation[] declaredAnnotations = field.getDeclaredAnnotations();
            if (declaredAnnotations.length > 0) {
                Arrays.stream(declaredAnnotations).forEach(annotation -> {
                    if (annotation instanceof DateTimeFormat) {
                        datePattern.set(((DateTimeFormat)annotation).pattern());
                    }
                });
            }
            String key = field.getName();
            Object value = field.get(obj);
            if (DataUtil.isNullOrEmpty(datePattern.get())) {
                mapEncode.put(key, value);
                continue;
            }
            map.put(key, DateUtil.dateToString((Date)value, datePattern.get()));
        }
        String url = DataUtil.toUrlEncoded(map, false);
        String urlEncoded = DataUtil.toUrlEncoded(mapEncode, false);
        return url + urlEncoded;
    }

    public static <T> T cloneBean(T source) {
        try {
            if (source == null) {
                return null;
            }
            return (T)DataUtil.jsonToObject(DataUtil.objectToJson(source), source.getClass());
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String setParameters(String format, Object data, int ... types) throws Exception {
        int type = types.length == 0 ? 0 : types[0];
        String WRAP_PARAM_PATTERN = "[><]";
        String OPTION_PARAM_PATTERN = "[\\[\\]]";
        String result = format;
        if (!format.contains("[")) {
            Field[] fields = data.getClass().getDeclaredFields();
            Pattern pattern = Pattern.compile("<(.*?)>");
            Matcher matcher = pattern.matcher(format);
            block0: while (matcher.find()) {
                String param = matcher.group(1);
                if (DataUtil.isNullOrEmpty(param)) continue;
                for (Field field : fields) {
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    if (!param.equals(fieldName)) continue;
                    String value = DataUtil.safeToString(field.get(data));
                    if (type == 0) {
                        result = result.replace(param, value);
                        continue block0;
                    }
                    if (type != 1 || DataUtil.isNullOrEmpty(value)) continue block0;
                    return value;
                }
            }
            if (type == 1) {
                return "";
            }
            result = result.replaceAll("[><]", "");
        } else {
            List<String> lstOptions = Arrays.asList(format.split("[\\[\\]]"));
            StringBuilder temp = new StringBuilder();
            for (int i = 0; i < lstOptions.size(); ++i) {
                if (i % 2 != 0) {
                    String paramOption = lstOptions.get(i);
                    String rsOption = DataUtil.setParameters(paramOption, data, 1);
                    lstOptions.set(i, rsOption);
                }
                temp.append(lstOptions.get(i));
            }
            result = DataUtil.setParameters(temp.toString(), data, 0);
        }
        return result;
    }

    public static String setParameters(String format, Map<String, Object> data, int ... types) {
        int type = types.length == 0 ? 0 : types[0];
        String WRAP_PARAM_PATTERN = "[><]";
        String OPTION_PARAM_PATTERN = "[\\[\\]]";
        String result = format;
        if (!format.contains("[")) {
            Pattern pattern = Pattern.compile("<(.*?)>");
            Matcher matcher = pattern.matcher(format);
            while (matcher.find()) {
                String param = matcher.group(1);
                if (DataUtil.isNullOrEmpty(param)) continue;
                String value = DataUtil.safeToString(data.get(param));
                if (type == 0) {
                    result = result.replace(param, value);
                    continue;
                }
                if (type != 1 || DataUtil.isNullOrEmpty(value)) continue;
                return value;
            }
            if (type == 1) {
                return "";
            }
            result = result.replaceAll("[><]", "");
        } else {
            List<String> lstOptions = Arrays.asList(format.split("[\\[\\]]"));
            StringBuilder temp = new StringBuilder();
            for (int i = 0; i < lstOptions.size(); ++i) {
                if (i % 2 != 0) {
                    String paramOption = lstOptions.get(i);
                    String rsOption = DataUtil.setParameters(paramOption, data, 1);
                    lstOptions.set(i, rsOption);
                }
                temp.append(lstOptions.get(i));
            }
            result = DataUtil.setParameters(temp.toString(), data, 0);
        }
        return result;
    }

    public static String prettyObject(Object object) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String objectToJson(Object object) {
        if (object == null) {
            return "";
        }
        try {
            return Singleton.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static <T> T objectToClass(Object object, Class<T> targetClass) {
        return (T)Singleton.getObjectMapper().convertValue(object, targetClass);
    }

    public static <T> List<T> objectToListClass(Object object, Class<T> targetClass) throws Exception {
        String jsonData = DataUtil.objectToJson(object);
        ObjectMapper objectMapper = Singleton.getObjectMapper();
        return (List)objectMapper.readValue(jsonData, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, targetClass));
    }

    public static String safeToString(Object obj1, String defaultValue) {
        if (obj1 == null) {
            return defaultValue;
        }
        return obj1.toString().trim();
    }

    public static String safeToString(Object obj1) {
        return DataUtil.safeToString(obj1, "");
    }

    public static Long safeToLong(Object obj1, Long defaultValue) {
        if (obj1 == null || obj1 instanceof String && DataUtil.isNullOrEmpty(DataUtil.safeToString(obj1))) {
            return defaultValue;
        }
        if (obj1 instanceof BigDecimal) {
            return ((BigDecimal)obj1).longValue();
        }
        if (obj1 instanceof BigInteger) {
            return ((BigInteger)obj1).longValue();
        }
        if (obj1 instanceof Double) {
            return ((Double)obj1).longValue();
        }
        try {
            return Long.parseLong(obj1.toString());
        }
        catch (NumberFormatException nfe) {
            log.error(nfe.getMessage(), (Throwable)nfe);
            return defaultValue;
        }
    }

    public static Long safeToLong(Object obj1) {
        return DataUtil.safeToLong(obj1, 0L);
    }

    public static Double safeToDouble(Object obj1, Double defaultValue) {
        if (obj1 == null || obj1 instanceof String && DataUtil.isNullOrEmpty(DataUtil.safeToString(obj1))) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(obj1.toString());
        }
        catch (NumberFormatException nfe) {
            log.error(nfe.getMessage(), (Throwable)nfe);
            return defaultValue;
        }
    }

    public static Double safeToDouble(Object obj1) {
        return DataUtil.safeToDouble(obj1, 0.0);
    }

    public static Short safeToShort(Object obj1, Short defaultValue) {
        if (obj1 == null || obj1 instanceof String && DataUtil.isNullOrEmpty(DataUtil.safeToString(obj1))) {
            return defaultValue;
        }
        try {
            return Short.parseShort(obj1.toString());
        }
        catch (NumberFormatException nfe) {
            log.error(nfe.getMessage(), (Throwable)nfe);
            return defaultValue;
        }
    }

    public static Short safeToShort(Object obj1) {
        return DataUtil.safeToShort(obj1, (short)0);
    }

    public static Integer safeToInt(Object obj1, Integer defaultValue) {
        if (obj1 == null || obj1 instanceof String && DataUtil.isNullOrEmpty(DataUtil.safeToString(obj1))) {
            return defaultValue;
        }
        try {
            String s = obj1.toString();
            if (s.contains(".")) {
                s = s.substring(0, s.lastIndexOf("."));
            }
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            log.error(nfe.getMessage(), (Throwable)nfe);
            return defaultValue;
        }
    }

    public static Integer safeToInt(Object obj1) {
        return DataUtil.safeToInt(obj1, 0);
    }

    public static BigDecimal safeToBigDecimal(Object obj1, BigDecimal defaultValue) {
        if (obj1 == null || obj1 instanceof String && DataUtil.isNullOrEmpty(DataUtil.safeToString(obj1))) {
            return defaultValue;
        }
        try {
            return new BigDecimal(obj1.toString());
        }
        catch (NumberFormatException nfe) {
            log.error(nfe.getMessage(), (Throwable)nfe);
            return BigDecimal.ZERO;
        }
    }

    public static BigDecimal safeToBigDecimal(Object obj1) {
        return DataUtil.safeToBigDecimal(obj1, BigDecimal.ZERO);
    }

    public static BigInteger safeToBigInteger(Object obj1) {
        return DataUtil.safeToBigInteger(obj1, BigInteger.ZERO);
    }

    public static BigInteger safeToBigInteger(Object obj1, BigInteger defaultValue) {
        if (obj1 == null || obj1 instanceof String && DataUtil.isNullOrEmpty(DataUtil.safeToString(obj1))) {
            return defaultValue;
        }
        try {
            return new BigInteger(obj1.toString());
        }
        catch (NumberFormatException nfe) {
            log.error(nfe.getMessage(), (Throwable)nfe);
            return defaultValue;
        }
    }

    public static Boolean safeToBoolean(Integer data) {
        return DataUtil.safeToBoolean(data, (Boolean)false);
    }

    public static Boolean safeToBoolean(Integer data, Boolean defaultValue) {
        if (DataUtil.isNullObject(data)) {
            return defaultValue;
        }
        return data.equals(1);
    }

    public static Boolean safeToBoolean(String data) {
        return DataUtil.safeToBoolean(data, (Boolean)false);
    }

    public static Boolean safeToBoolean(String data, Boolean defaultValue) {
        if (DataUtil.isNullOrEmpty(data)) {
            return defaultValue;
        }
        return data.equals("true") || data.equals("1");
    }

    public static Boolean safeToBoolean(Double data) {
        return DataUtil.safeToBoolean(data, (Boolean)false);
    }

    public static Boolean safeToBoolean(Double data, Boolean defaultValue) {
        if (DataUtil.isNullObject(data)) {
            return defaultValue;
        }
        return data == 1.0;
    }

    public static Boolean safeToBoolean(Long data) {
        return DataUtil.safeToBoolean(data, (Boolean)false);
    }

    public static Boolean safeToBoolean(Long data, Boolean defaultValue) {
        if (DataUtil.isNullObject(data)) {
            return defaultValue;
        }
        return data == 1L;
    }

    public static Boolean safeToBoolean(Boolean data) {
        return DataUtil.safeToBoolean(data, (Boolean)false);
    }

    public static Boolean safeToBoolean(Boolean data, Boolean defaultValue) {
        if (DataUtil.isNullObject(data)) {
            return defaultValue;
        }
        return data;
    }

    public static <T> List<T> safeToList(List<T> data, List<T> defaultValue) {
        if (DataUtil.isNullOrEmpty(data)) {
            return defaultValue;
        }
        return data;
    }

    public static <T> List<T> safeToList(List<T> data) {
        return DataUtil.safeToList(data, new ArrayList());
    }

    public static <T> Set<T> safeToSet(Set<T> data, Set<T> defaultValue) {
        if (DataUtil.isNullOrEmpty(data)) {
            return defaultValue;
        }
        return data;
    }

    public static <T> Set<T> safeToSet(Set<T> data) {
        return DataUtil.safeToSet(data, new HashSet());
    }

    public static <T1, T2> Map<T1, T2> safeToMap(Map<T1, T2> data, Map<T1, T2> defaultValue) {
        if (DataUtil.isNullOrEmpty(data)) {
            return defaultValue;
        }
        return data;
    }

    public static <T1, T2> Map<T1, T2> safeToMap(Map<T1, T2> data) {
        return DataUtil.safeToMap(data, new HashMap());
    }

    public static String safeToPhoneNumber(String phoneNumber) {
        String REGEX_START_PHONE_NUMBER = "^(?:\\+84|0)";
        String START_PHONE_NUMBER = "84";
        if (DataUtil.isNullOrEmpty(phoneNumber = DataUtil.removeSpecialChar(DataUtil.safeToString(phoneNumber)))) {
            return phoneNumber;
        }
        Pattern pattern = Pattern.compile("^(?:\\+84|0)");
        if (pattern.matcher(phoneNumber).find()) {
            return phoneNumber.replaceAll("^(?:\\+84|0)", "84");
        }
        return phoneNumber;
    }

    public static Long safeAbs(Long number) {
        return DataUtil.safeAbs(number, 0L);
    }

    public static Long safeAbs(Long number, Long defaultValue) {
        if (number == null) {
            if (defaultValue == null) {
                return 0L;
            }
            return defaultValue < 0L ? -defaultValue.longValue() : defaultValue;
        }
        return number < 0L ? -number.longValue() : number;
    }

    public static boolean safeEqual(Integer obj1, Integer obj2) {
        if (Objects.equals(obj1, obj2)) {
            return true;
        }
        return obj1 != null && obj2 != null && obj1.compareTo(obj2) == 0;
    }

    public static boolean safeEqual(Double obj1, Double obj2) {
        if (Objects.equals(obj1, obj2)) {
            return true;
        }
        return obj1 != null && obj2 != null && obj1.compareTo(obj2) == 0;
    }

    public static boolean safeEqual(Long obj1, Long obj2) {
        if (Objects.equals(obj1, obj2)) {
            return true;
        }
        return obj1 != null && obj2 != null && obj1.compareTo(obj2) == 0;
    }

    public static boolean safeEqual(BigInteger obj1, BigInteger obj2) {
        if (Objects.equals(obj1, obj2)) {
            return true;
        }
        return obj1 != null && obj1.equals(obj2);
    }

    public static boolean safeEqual(Short obj1, Short obj2) {
        if (Objects.equals(obj1, obj2)) {
            return true;
        }
        return obj1 != null && obj2 != null && obj1.compareTo(obj2) == 0;
    }

    public static boolean safeEqualCaseSensitive(String obj1, String obj2) {
        return Objects.equals(obj1, obj2);
    }

    public static boolean safeEqual(String obj1, String obj2) {
        if (Objects.equals(obj1, obj2)) {
            return true;
        }
        return obj1 != null && obj1.equalsIgnoreCase(obj2);
    }

    public static boolean safeEqual(Object obj1, Object obj2) {
        try {
            if (obj1 == null && obj2 == null) {
                return true;
            }
            if (obj1 == null || obj2 == null) {
                return false;
            }
            if (obj1 instanceof Date) {
                return DateUtil.compare(DateUtil.safeToDate(obj1), DateUtil.safeToDate(obj2)) == 0;
            }
            if (obj1 instanceof String) {
                return String.valueOf(obj1).equals(String.valueOf(obj2));
            }
            if (obj1 instanceof Long) {
                return DataUtil.safeToLong(obj1).equals(DataUtil.safeToLong(obj2));
            }
            if (obj1 instanceof Integer) {
                return DataUtil.safeToInt(obj1).equals(DataUtil.safeToInt(obj2));
            }
            return obj1 == obj2;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean safeEqual(Boolean obj1, Boolean obj2) {
        return Objects.equals(obj1, obj2);
    }

    public static String safeTrim(String obj) {
        if (obj == null) {
            return null;
        }
        return obj.trim();
    }

    public static String safeToUpperCase(String obj) {
        if (obj == null) {
            return null;
        }
        return obj.toUpperCase();
    }

    public static String safeToLowerCase(String obj) {
        if (obj == null) {
            return null;
        }
        return obj.toLowerCase();
    }

    public static Boolean isEmail(String email) {
        return email.matches(EMAIL_PATTERN);
    }

    public static boolean isBase64(String string) {
        return string.matches(REGEX_BASE64);
    }

    public static boolean isNumber(String str) {
        return str.matches("(\\d+)");
    }

    public static boolean isNullOrEmpty(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Object[] collection) {
        return collection == null || collection.length == 0;
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNullOrZero(Long value) {
        return value == null || value.equals(0L);
    }

    public static boolean isNullOrZero(Double value) {
        return value == null || value == 0.0;
    }

    public static boolean isNullOrZero(String value) {
        return value == null || DataUtil.safeToLong(value).equals(0L);
    }

    public static boolean isNullOrZero(Integer value) {
        return value == null || value.equals(0);
    }

    public static boolean isNullOrZero(BigDecimal value) {
        return value == null || value.compareTo(BigDecimal.ZERO) == 0;
    }

    public static boolean isNullObject(Object obj1) {
        if (obj1 == null) {
            return true;
        }
        if (obj1 instanceof String) {
            return DataUtil.isNullOrEmpty(obj1.toString());
        }
        return false;
    }

    public static String clearSpace(String data) {
        if (DataUtil.isNullOrEmpty(data)) {
            return "";
        }
        return data.replaceAll("\\s+", "");
    }

    public static String cleanSpace(String data) {
        if (DataUtil.isNullOrEmpty(data)) {
            return "";
        }
        return DataUtil.safeTrim(data).replaceAll("\\s+", " ");
    }

    public static String removeUnicode(String input) {
        String nfdNormalizedString = Normalizer.normalize(input, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(nfdNormalizedString).replaceAll("");
    }

    public static String removeSpecialChar(String input) {
        String REGEX_SPECIAL_CHAR = "[^a-zA-Z0-9]";
        if (DataUtil.isNullOrEmpty(input)) {
            return input;
        }
        return input.replaceAll("[^a-zA-Z0-9]", "");
    }

    public static String toUsername(String name) {
        String res = DataUtil.removeUnicode(name);
        String[] separatedName = res.split(" ");
        int len = separatedName.length - 1;
        StringBuilder username = new StringBuilder(separatedName[len]);
        for (int i = 0; i < len; ++i) {
            username.append(separatedName[i].charAt(0));
        }
        return username.toString();
    }

    public static Map<String, Object> toMap(List<Object> data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!DataUtil.isNullOrEmpty(data)) {
            for (int i = 0; i < data.size(); i += 2) {
                String key = DataUtil.safeToString(data.get(i));
                Object value = data.get(i + 1);
                result.put(key, value);
            }
        }
        return result;
    }

    public static String generateOTP(int length) {
        String numbers = "0123456789";
        StringBuilder otp = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            otp.append(numbers.charAt(ThreadLocalRandom.current().nextInt(numbers.length())));
        }
        return otp.toString();
    }

    public static String generateQrCode(String data, int width, int height) {
        Object resultImage = "";
        if (data != null && !data.isEmpty()) {
            EnumMap<EncodeHintType, Object> hints = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
            hints.put(EncodeHintType.CHARACTER_SET, (Object)"utf-8");
            hints.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.M);
            hints.put(EncodeHintType.MARGIN, (Object)2);
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                QRCodeWriter writer = new QRCodeWriter();
                BitMatrix bitMatrix = writer.encode(data, BarcodeFormat.QR_CODE, width, height, hints);
                BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
                ImageIO.write((RenderedImage)bufferedImage, "png", os);
                resultImage = "data:image/png;base64," + new String(Base64.getEncoder().encode(os.toByteArray()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultImage;
    }

    public static String toSlug(String str, Boolean replaceSpecialChar) {
        str = DataUtil.removeUnicode(str);
        str = str.toLowerCase();
        StringBuilder sb = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (!Character.isLetterOrDigit(c) && !Character.isWhitespace(c) && replaceSpecialChar.booleanValue()) continue;
            sb.append(c);
        }
        return sb.toString().trim().replaceAll("\\s+", "-");
    }

    public static String toLikeConditional(String conditional) {
        if (DataUtil.isNullOrEmpty(conditional)) {
            return "%%";
        }
        return "%" + conditional.replace("%", "\\%").replace("_", "\\_").toUpperCase() + "%";
    }

    public static Double round(Double number, Integer digits) {
        if (DataUtil.isNullObject(number)) {
            return null;
        }
        number = DataUtil.safeToDouble(number);
        if ((digits = DataUtil.safeToInt(digits)) < 0) {
            throw new IllegalArgumentException("S\u1ed1 ch\u1eef s\u1ed1 sau d\u1ea5u th\u1eadp ph\u00e2n ph\u1ea3i l\u00e0 s\u1ed1 nguy\u00ean d\u01b0\u01a1ng.");
        }
        BigDecimal bd = BigDecimal.valueOf(number);
        bd = bd.setScale((int)digits, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static String encodesBase64(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public static String decodeBase64(String dataBase64) {
        byte[] decodedBytes = Base64.getDecoder().decode(dataBase64);
        return new String(decodedBytes);
    }

    public static ByteArrayOutputStream toByteArrayOutputStream(byte[] byteArray) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.writeBytes(byteArray);
        return outputStream;
    }

    public static <T> List<T> difference(Collection<T> lstOne, Collection<T> lstTwo) {
        if (DataUtil.isNullOrEmpty(lstOne)) {
            return new ArrayList<T>(lstTwo);
        }
        if (DataUtil.isNullOrEmpty(lstTwo)) {
            return new ArrayList<T>(lstOne);
        }
        ArrayList<T> differences = new ArrayList<T>(lstOne);
        differences.removeAll(lstTwo);
        return differences;
    }

    public static <T> List<T> onlyInFirstList(List<T> firstList, List<T> secondList) {
        if (DataUtil.isNullOrEmpty(firstList)) {
            return Collections.emptyList();
        }
        if (DataUtil.isNullOrEmpty(secondList)) {
            return firstList;
        }
        return new ArrayList(CollectionUtils.removeAll(firstList, secondList));
    }

    public static List<Object> removeDuplicate(List<Object> data) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object item : data) {
            if (item instanceof String) {
                item = DataUtil.safeToString(item).toLowerCase();
            }
            if (result.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static <T> List<T> removeDuplicate(List<T> data, String fieldName) {
        try {
            Field field = data.get(0).getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            HashSet<Object> set = new HashSet<Object>();
            ArrayList<T> result = new ArrayList<T>();
            for (T item : data) {
                Object value = field.get(item);
                if (value instanceof String) {
                    value = DataUtil.safeToString(value).toLowerCase();
                }
                if (!set.add(value)) continue;
                result.add(item);
            }
            return result;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static <T> List<T> removeDuplicate(List<T> data, List<String> listFieldName) {
        try {
            List listField = listFieldName.stream().map(fieldName -> {
                try {
                    Field field = data.get(0).getClass().getDeclaredField((String)fieldName);
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            HashSet<String> set = new HashSet<String>();
            ArrayList<T> result = new ArrayList<T>();
            for (Object item : data) {
                List listValue = listField.stream().map(field -> {
                    try {
                        return DataUtil.safeToString(field.get(item)).toLowerCase();
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.toList());
                if (!set.add(String.join((CharSequence)",", listValue))) continue;
                result.add(item);
            }
            return result;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static Boolean hasDuplicate(List<Object> data) {
        List<Object> listRemoveDuplicate = DataUtil.removeDuplicate(data);
        return listRemoveDuplicate.size() < data.size();
    }

    public static <T> Boolean hasDuplicate(List<T> data, String fieldName) {
        List<T> listRemoveDuplicate = DataUtil.removeDuplicate(data, fieldName);
        return listRemoveDuplicate.size() < data.size();
    }

    public static <T> Boolean hasDuplicate(List<T> data, List<String> listFieldName) {
        List<T> listRemoveDuplicate = DataUtil.removeDuplicate(data, listFieldName);
        return listRemoveDuplicate.size() < data.size();
    }

    public static <T> List<T> getLargestList(List<List<T>> sourceData) {
        if (!sourceData.isEmpty()) {
            return sourceData.stream().max(Comparator.comparingInt(List::size)).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    public static Boolean hasCommonItem(List<?> firstList, List<?> secondList) {
        if (DataUtil.isNullOrEmpty(firstList) || DataUtil.isNullOrEmpty(secondList)) {
            return false;
        }
        return firstList.stream().anyMatch(secondList::contains);
    }

    public static String getMapValue(Map<?, ?> data, String key) {
        if (DataUtil.isNullOrEmpty(data)) {
            return "";
        }
        return DataUtil.safeToString(data.get(key));
    }

    public static double getBase64Size(String data) {
        return DataUtil.getBase64Size(data, FileSizeUnit.MB);
    }

    public static double getBase64Size(String data, FileSizeUnit unit) {
        int unitMultiplier = -1;
        switch (unit) {
            case B: {
                unitMultiplier = 1;
                break;
            }
            case KB: {
                unitMultiplier = 1024;
                break;
            }
            case MB: {
                unitMultiplier = 0x100000;
                break;
            }
            case GB: {
                unitMultiplier = 0x40000000;
            }
        }
        if (unitMultiplier == -1) {
            throw new IllegalArgumentException("Invalid unit");
        }
        byte[] bytes = Base64.getDecoder().decode(data);
        double size = (double)bytes.length / (double)unitMultiplier;
        return Math.round(size);
    }

    public static String getFirstName(String fullName) {
        if (DataUtil.isNullOrEmpty(fullName)) {
            return "";
        }
        String[] nameParts = fullName.trim().split("\\s+");
        return nameParts[0];
    }

    public static String getLastName(String fullName) {
        if (DataUtil.isNullOrEmpty(fullName)) {
            return "";
        }
        String[] nameParts = fullName.trim().split("\\s+");
        return nameParts[nameParts.length - 1];
    }

    public static String numberToCurrency(Long number, String prefix, String suffix) {
        NumberFormat format = NumberFormat.getCurrencyInstance();
        format.setMaximumFractionDigits(0);
        format.setCurrency(Currency.getInstance("VND"));
        String currencyStr = format.format(number).replace("VND", "");
        StringBuilder result = new StringBuilder();
        if (!DataUtil.isNullOrEmpty(prefix)) {
            result.append(prefix).append(" ");
        }
        result.append(currencyStr);
        if (!DataUtil.isNullOrEmpty(suffix)) {
            result.append(" ").append(suffix);
        }
        return result.toString();
    }

    @SafeVarargs
    private static void setFieldData(Tuple sourceItem, String sourceFieldName, Field targetFieldItem, Object target, Map<String, String> dateFormats, Map<String, Object> ... options) throws IllegalAccessException {
        Integer digitsRound = null;
        if (options.length > 0) {
            Map<String, Object> option = options[0];
            digitsRound = DataUtil.isNullObject(option.get("digitsRound")) ? null : DataUtil.safeToInt(option.get("digitsRound"));
        }
        targetFieldItem.setAccessible(true);
        Class<?> targetFieldType = targetFieldItem.getType();
        String targetFieldTypeName = targetFieldType.getName();
        String dateFormat = dateFormats.size() == 1 ? dateFormats.get("ALL") : dateFormats.get(sourceFieldName);
        Object sourceItemData = sourceItem.get(sourceFieldName);
        if (sourceItemData == null) {
            return;
        }
        DataTypeClassName targetFieldClassName = DataTypeClassName.get(targetFieldTypeName);
        if (DataUtil.isNullObject((Object)targetFieldClassName)) {
            if (Object.class.isAssignableFrom(targetFieldType)) {
                targetFieldItem.set(target, DataUtil.jsonToObject(DataUtil.safeToString(sourceItemData), targetFieldType));
            }
            return;
        }
        switch (targetFieldClassName) {
            case STRING: {
                if (sourceItemData instanceof Date) {
                    targetFieldItem.set(target, DateUtil.dateToString(DateUtil.safeToDate(sourceItemData), dateFormat));
                    break;
                }
                targetFieldItem.set(target, DataUtil.safeToString(sourceItemData));
                break;
            }
            case LONG: 
            case PRIMITIVE_LONG: {
                targetFieldItem.set(target, DataUtil.safeToLong(sourceItemData));
                break;
            }
            case DOUBLE: 
            case PRIMITIVE_DOUBLE: {
                if (DataUtil.isNullOrZero(digitsRound)) {
                    targetFieldItem.set(target, DataUtil.safeToDouble(sourceItemData));
                    break;
                }
                targetFieldItem.set(target, DataUtil.round(DataUtil.safeToDouble(sourceItemData), digitsRound));
                break;
            }
            case BOOLEAN: 
            case PRIMITIVE: {
                targetFieldItem.set(target, "true".equalsIgnoreCase(DataUtil.safeToString(sourceItemData)) || "1".equalsIgnoreCase(DataUtil.safeToString(sourceItemData)));
                break;
            }
            case DATE: {
                targetFieldItem.set(target, DateUtil.safeToDate(sourceItemData));
                break;
            }
            case BIG_DECIMAL: {
                targetFieldItem.set(target, DataUtil.safeToBigDecimal(sourceItemData));
                break;
            }
            case INTEGER: 
            case INT: {
                targetFieldItem.set(target, DataUtil.safeToInt(sourceItemData));
                break;
            }
            case LIST: {
                ParameterizedType parameterizedType;
                Type[] typeArguments;
                Type genericType = targetFieldItem.getGenericType();
                if (!(genericType instanceof ParameterizedType) || (typeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length <= 0 || !(typeArguments[0] instanceof Class)) break;
                Class type = (Class)typeArguments[0];
                targetFieldItem.set(target, DataUtil.jsonToObject(DataUtil.safeToString(sourceItemData), type));
                break;
            }
        }
    }

    @SafeVarargs
    public static <T> List<T> tupleToObject(List<Tuple> listSource, Class<T> classTarget, Map<String, String> dateFormats, Map<String, Object> ... options) {
        try {
            ArrayList<T> result = new ArrayList<T>();
            for (Tuple sourceItem : listSource) {
                Field[] targetFields;
                Constructor<T> cons = classTarget.getConstructor(new Class[0]);
                T target = cons.newInstance(new Object[0]);
                for (Field targetFieldItem : targetFields = target.getClass().getDeclaredFields()) {
                    String fieldName = targetFieldItem.getName().toLowerCase();
                    List sourceFields = sourceItem.getElements();
                    try {
                        List collect = sourceFields.stream().filter(item -> {
                            String sourceFieldNameRemoveUnderscore = item.getAlias().replace("_", "");
                            return fieldName.equalsIgnoreCase(sourceFieldNameRemoveUnderscore);
                        }).collect(Collectors.toList());
                        String sourceFieldName = DataUtil.isNullOrEmpty(collect) ? "" : ((TupleElement)collect.get(0)).getAlias();
                        DataUtil.setFieldData(sourceItem, sourceFieldName, targetFieldItem, target, dateFormats, options);
                    }
                    catch (Exception e) {
                        String message = e.getMessage();
                        if (DataUtil.safeEqual(message, "Unknown alias []")) continue;
                        log.error(message);
                    }
                }
                result.add(target);
            }
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return new ArrayList();
        }
    }

    @SafeVarargs
    public static <T> List<T> tupleToObject(List<Tuple> listSource, Class<T> classTarget, String dateFormat, Map<String, Object> ... options) {
        HashMap<String, String> dateFormats = new HashMap<String, String>();
        dateFormats.put("ALL", dateFormat);
        return DataUtil.tupleToObject(listSource, classTarget, dateFormats, options);
    }

    @SafeVarargs
    public static <T> List<T> tupleToObject(List<Tuple> listSource, Class<T> classTarget, Map<String, Object> ... options) {
        return DataUtil.tupleToObject(listSource, classTarget, DATE_FORMAT, options);
    }

    public static <T> T tupleToObject(Tuple source, Class<T> classTarget, Map<String, String> dateFormats) {
        try {
            Field[] targetFields;
            Constructor<T> cons = classTarget.getConstructor(new Class[0]);
            T target = cons.newInstance(new Object[0]);
            for (Field targetFieldItem : targetFields = target.getClass().getDeclaredFields()) {
                String fieldName = targetFieldItem.getName().toLowerCase();
                List sourceFields = source.getElements();
                try {
                    List collect = sourceFields.stream().filter(item -> {
                        String sourceFieldNameRemoveUnderscore = item.getAlias().replace("_", "");
                        return fieldName.equalsIgnoreCase(sourceFieldNameRemoveUnderscore);
                    }).collect(Collectors.toList());
                    if (DataUtil.isNullOrEmpty(collect)) continue;
                    String sourceFieldName = ((TupleElement)collect.get(0)).getAlias();
                    DataUtil.setFieldData(source, sourceFieldName, targetFieldItem, target, dateFormats, new Map[0]);
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (DataUtil.safeEqual(message, "Unknown alias []")) continue;
                    log.error(message);
                }
            }
            return target;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T tupleToObject(Tuple source, Class<T> classTarget, String dateFormat) {
        HashMap<String, String> dateFormats = new HashMap<String, String>();
        dateFormats.put("ALL", dateFormat);
        return DataUtil.tupleToObject(source, classTarget, dateFormats);
    }

    public static <T> T tupleToObject(Tuple source, Class<T> classTarget) {
        return DataUtil.tupleToObject(source, classTarget, DATE_FORMAT);
    }

    public static String safeHandlingHtml(String content) {
        PolicyFactory policy = new HtmlPolicyBuilder().allowAttributes(new String[]{"src", "style", "width"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"href"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"class"}).onElements(new String[]{"p"}).allowStandardUrlProtocols().allowElements(new String[]{"a", "img", "p", "b", "div", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "li", "strong", "em", "u", "s"}).toFactory();
        return policy.sanitize(content);
    }

    public static <T> T jsonToObject(String json, Class<T> classTarget) {
        try {
            if (DataUtil.isNullOrEmpty(json)) {
                return null;
            }
            return (T)Singleton.getObjectMapper().readValue(json, classTarget);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> jsonToListObject(String json, Class<T[]> classTarget) {
        try {
            if (DataUtil.isNullOrEmpty(json)) {
                return Collections.emptyList();
            }
            return Arrays.asList((Object[])Singleton.getObjectMapper().readValue(json, classTarget));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static String incrementCode(String code, String prefix, Integer indexLength) {
        code = DataUtil.safeToString(code);
        Integer index = DataUtil.safeToInt(code = code.replace(prefix = DataUtil.safeToString(prefix), ""));
        Integer nextIndex = index + 1;
        int nextIndexLength = DataUtil.safeToString(nextIndex).length();
        if (nextIndexLength > indexLength) {
            return String.format("%s%d", prefix, nextIndex);
        }
        return String.format("%s%s%s", prefix, "0".repeat(indexLength - nextIndexLength), nextIndex);
    }

    public static String incrementCode(String code, String prefix, String suffix, Integer indexLength) {
        code = DataUtil.safeToString(code);
        prefix = DataUtil.safeToString(prefix);
        suffix = DataUtil.safeToString(suffix);
        Integer index = DataUtil.safeToInt(code = code.replace(prefix, "").replaceAll(suffix, ""));
        Integer nextIndex = index + 1;
        int nextIndexLength = DataUtil.safeToString(nextIndex).length();
        if (nextIndexLength > indexLength) {
            return String.format("%s%d%s", prefix, nextIndex, suffix);
        }
        StringBuilder result = new StringBuilder(prefix);
        for (int i = 0; i < indexLength - nextIndexLength; ++i) {
            result.append("0");
        }
        result.append(nextIndex);
        result.append(suffix);
        return result.toString();
    }

    public static String generateCode(String prefix, String suffix, Integer maxIndexLength, Integer startIndex) {
        prefix = DataUtil.safeToString(prefix);
        suffix = DataUtil.safeToString(suffix);
        String format = "%s%0" + maxIndexLength + "d%s";
        return String.format(format, prefix, startIndex, suffix);
    }

    public static String updateCode(String code, String oldPrefix, String oldSuffix, String newPrefix, String newSuffix, Integer newIndexLength) {
        code = DataUtil.safeToString(code);
        oldPrefix = DataUtil.safeToString(oldPrefix);
        oldSuffix = DataUtil.safeToString(oldSuffix);
        newPrefix = DataUtil.safeToString(newPrefix);
        newSuffix = DataUtil.safeToString(newSuffix);
        newIndexLength = DataUtil.safeToInt(newIndexLength);
        Integer currentIndex = DataUtil.safeToInt(code = code.replace(oldPrefix, "").replaceAll(oldSuffix, ""));
        Integer currentIndexLength = DataUtil.safeToString(currentIndex).length();
        if (currentIndexLength >= newIndexLength) {
            return String.format("%s%d%s", newPrefix, currentIndex, newSuffix);
        }
        StringBuilder result = new StringBuilder(newPrefix);
        for (int i = 0; i < newIndexLength - currentIndexLength; ++i) {
            result.append("0");
        }
        result.append(currentIndex);
        result.append(newSuffix);
        return result.toString();
    }

    public static <T> T copyProperties(Object source, Class<T> classTarget) {
        try {
            Constructor<T> cons = classTarget.getConstructor(new Class[0]);
            T target = cons.newInstance(new Object[0]);
            BeanUtils.copyProperties((Object)source, target);
            return target;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T copyProperties(Object source, Class<T> classTarget, String ... ignoreProperties) {
        try {
            Constructor<T> cons = classTarget.getConstructor(new Class[0]);
            T target = cons.newInstance(new Object[0]);
            BeanUtils.copyProperties((Object)source, target, (String[])ignoreProperties);
            return target;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getFieldValue(Object obj, String fieldName) throws Exception {
        Class<?> myClass = obj.getClass();
        Field field = myClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(obj);
    }

    public static String substring(String data, int length) {
        return data.length() > length ? DataUtil.substring(data, 0, length) : data;
    }

    public static String substring(String data, int beginIndex, int endIndex) {
        if (DataUtil.isNullOrEmpty(data)) {
            return data;
        }
        return data.substring(beginIndex, endIndex);
    }

    public static <T> T listToObject(List<String> listSource, Class<T> classTarget, String dateFormat) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor<T> cons = classTarget.getConstructor(new Class[0]);
        T target = cons.newInstance(new Object[0]);
        Field[] listField = target.getClass().getDeclaredFields();
        for (int i = 0; i < listSource.size(); ++i) {
            try {
                if (i >= listField.length) break;
                String source = listSource.get(i);
                Field field = listField[i];
                field.setAccessible(true);
                Class<?> fieldType = field.getType();
                String targetFieldTypeName = fieldType.getName();
                DataTypeClassName fieldClassName = DataTypeClassName.get(targetFieldTypeName);
                if (DataUtil.isNullObject((Object)fieldClassName)) continue;
                switch (fieldClassName) {
                    case STRING: {
                        field.set(target, DataUtil.safeToString(source));
                        break;
                    }
                    case LONG: 
                    case PRIMITIVE_LONG: {
                        field.set(target, DataUtil.safeToLong(source, null));
                        break;
                    }
                    case DOUBLE: 
                    case PRIMITIVE_DOUBLE: {
                        field.set(target, DataUtil.safeToDouble(source, null));
                        break;
                    }
                    case BOOLEAN: 
                    case PRIMITIVE: {
                        field.set(target, "true".equalsIgnoreCase(DataUtil.safeToString(source)) || "1".equalsIgnoreCase(DataUtil.safeToString(source)));
                        break;
                    }
                    case DATE: {
                        field.set(target, DateUtil.stringToDate(source, dateFormat));
                        break;
                    }
                    case BIG_DECIMAL: {
                        field.set(target, DataUtil.safeToBigDecimal(source, null));
                        break;
                    }
                    case INTEGER: 
                    case INT: {
                        field.set(target, DataUtil.safeToInt(source, null));
                        break;
                    }
                }
                continue;
            }
            catch (Exception e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return target;
    }

    public static <T> List<String> objectToList(T source, String dateFormat) throws IllegalAccessException {
        Field[] listField = source.getClass().getDeclaredFields();
        ArrayList<String> result = new ArrayList<String>();
        for (Field field : listField) {
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            String targetFieldTypeName = fieldType.getName();
            DataTypeClassName fieldClassName = DataTypeClassName.get(targetFieldTypeName);
            if (DataUtil.isNullObject((Object)fieldClassName)) continue;
            if (fieldClassName == DataTypeClassName.DATE) {
                result.add(DateUtil.dateToString((Date)field.get(source), dateFormat));
                continue;
            }
            result.add(DataUtil.safeToString(field.get(source)));
        }
        return result;
    }

    public static enum FileSizeUnit {
        B,
        KB,
        MB,
        GB;

    }

    public static class PARAM_TYPE {
        public static final int PARAM_GENERAL = 0;
        public static final int PARAM_OPTION = 1;
    }

    public static final class CONVERT_QUERY_RESULT_OPTIONS {
        public static final String DIGITS_ROUND = "digitsRound";
    }

    public static enum DataTypeClassName {
        STRING(String.class.getName()),
        LONG(Long.class.getName()),
        PRIMITIVE_LONG(Long.TYPE.getName()),
        DOUBLE(Double.class.getName()),
        PRIMITIVE_DOUBLE(Double.TYPE.getName()),
        BOOLEAN(Boolean.class.getName()),
        PRIMITIVE(Boolean.TYPE.getName()),
        DATE(Date.class.getName()),
        BIG_DECIMAL(BigDecimal.class.getName()),
        INTEGER(Integer.class.getName()),
        INT(Integer.TYPE.getName()),
        OBJECT(Objects.class.getName()),
        LIST(List.class.getName());

        public final String value;
        private static final Map<String, DataTypeClassName> lookup;

        public static DataTypeClassName get(String value) {
            return lookup.get(value);
        }

        private DataTypeClassName(String value) {
            this.value = value;
        }

        static {
            lookup = new HashMap<String, DataTypeClassName>();
            for (DataTypeClassName d : DataTypeClassName.values()) {
                lookup.put(d.value, d);
            }
        }
    }
}

