/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.anhtd081095.util;

import io.gitlab.anhtd081095.util.DataUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.LocalDate;

public class DateUtil {
    private static final Logger log = LogManager.getLogger(DateUtil.class);

    public static Date safeToDate(Object obj1) {
        if (obj1 == null) {
            return null;
        }
        return (Date)obj1;
    }

    public static int compare(String first, String second, String pattern) throws ParseException {
        Date secondDate;
        SimpleDateFormat parser = new SimpleDateFormat(pattern);
        Date firstDate = parser.parse(first);
        if (firstDate.after(secondDate = parser.parse(second))) {
            return 1;
        }
        if (firstDate.equals(secondDate)) {
            return 0;
        }
        return -1;
    }

    public static int compare(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new NullPointerException();
        }
        if (date1.after(date2)) {
            return 1;
        }
        if (date1.equals(date2)) {
            return 0;
        }
        return -1;
    }

    public static Date stringToDate(String value, String pattern) {
        if (!DataUtil.isNullOrEmpty(value)) {
            SimpleDateFormat dateTime = new SimpleDateFormat(pattern);
            dateTime.setLenient(false);
            try {
                return dateTime.parse(value);
            }
            catch (ParseException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                return null;
            }
        }
        return null;
    }

    public static String dateToString(Date date, String pattern) {
        if (date == null || DataUtil.isNullOrEmpty(pattern)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern, new Locale("vi"));
        return df.format(date);
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int lastDate = calendar.getActualMaximum(5);
        calendar.set(5, lastDate);
        return calendar.getTime();
    }

    public static Date getLastDayOfMonth(@Nonnull Integer month, @Nonnull Integer year) {
        Date date = DateUtil.stringToDate(String.format("%d/%d", month, year), "MM/yyyy");
        if (DataUtil.isNullObject(date)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int lastDate = calendar.getActualMaximum(5);
        calendar.set(5, lastDate);
        return calendar.getTime();
    }

    public static Date getFirstDayOfMonth(Date date) {
        LocalDate today = new LocalDate((Object)date);
        return today.dayOfMonth().withMinimumValue().toDate();
    }

    public static Date getFirstDayOfMonth(@Nonnull Integer month, @Nonnull Integer year) {
        Date date = DateUtil.stringToDate(String.format("%d/%d", month, year), "MM/yyyy");
        if (DataUtil.isNullObject(date)) {
            return null;
        }
        LocalDate today = new LocalDate((Object)date);
        return today.dayOfMonth().withMinimumValue().toDate();
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth(Date nowDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(nowDate);
        return calendar.get(2) + 1;
    }

    public static int getDate(Date nowDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(nowDate);
        return calendar.get(5);
    }

    public static int getHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static int getMinute(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(12);
    }

    public static int getSecond(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(13);
    }

    public static int getMillisecond(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(14);
    }

    public static Long getTimeMillisecond(Date date) {
        if (DataUtil.isNullObject(date)) {
            return null;
        }
        return date.getTime();
    }

    public static int getDayOfYear(Date date) {
        Calendar ca1 = Calendar.getInstance();
        ca1.setTime(date);
        return ca1.get(6);
    }

    public static Date getStartOfDay(Date date) {
        return DateUtil.setTime(date, 0, 0, 0, 0);
    }

    public static Date getEndOfDay(Date date) {
        return DateUtil.setTime(date, 23, 59, 59, 999);
    }

    public static Date addSecond(Date date, int period) {
        if (DataUtil.isNullObject(date)) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(13, period);
        return cal.getTime();
    }

    public static Date addMinute(Date date, int period) {
        if (DataUtil.isNullObject(date)) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, period);
        return cal.getTime();
    }

    public static Date addHour(Date date, int period) {
        if (DataUtil.isNullObject(date)) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(10, period);
        return cal.getTime();
    }

    public static Date addDate(Date date, int period) {
        if (DataUtil.isNullObject(date)) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, period);
        return cal.getTime();
    }

    public static Date addMonth(Date date, int period) {
        if (DataUtil.isNullObject(date)) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, period);
        return cal.getTime();
    }

    public static Date addYear(Date date, int period) {
        if (DataUtil.isNullObject(date)) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, period);
        return cal.getTime();
    }

    public static Date setTime(Date date, int hour, int minute, int second, int millisecond) {
        if (DataUtil.isNullObject(date)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return calendar.getTime();
    }

    public static boolean isDate(String str, String datePattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
        try {
            sdf.setLenient(false);
            Date date = sdf.parse(str);
            if (date == null) {
                return false;
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    public static Double diffDate(Date firstDate, Date secondDate, TimeUnit timeUnit) {
        long timeDifference = secondDate.getTime() - firstDate.getTime();
        return (double)timeDifference / (double)timeUnit.toMillis(1L);
    }

    public static Integer getQuantityDayOfMonth(String dateStr, String format) {
        Date date = DateUtil.stringToDate(dateStr, format);
        Date lastDay = DateUtil.getLastDayOfMonth(date);
        return DateUtil.getDate(lastDay);
    }

    public static Long convertTimeUnit(Long sourceTime, TimeUnit srcUnit, TimeUnit desUnit) {
        return srcUnit.convert(sourceTime, desUnit);
    }
}

