/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.anhtd081095.util;

import com.documents4j.api.DocumentType;
import com.documents4j.api.IConverter;
import com.documents4j.job.LocalConverter;
import io.gitlab.anhtd081095.util.CollectionUtil;
import io.gitlab.anhtd081095.util.DataUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FileUtil {
    private static final Logger log = LogManager.getLogger(FileUtil.class);

    public static String convertFileToBase64(File file) {
        try {
            byte[] data = FileUtils.readFileToByteArray((File)file);
            return new String(Base64.getEncoder().encode(data));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static File base64ToFile(String base64, String fileType) throws Exception {
        String tmpdir = System.getProperty("java.io.tmpdir");
        String filePath = String.format("%s/%s.%s", tmpdir, System.currentTimeMillis(), fileType);
        byte[] data = Base64.getDecoder().decode(base64);
        try (FileOutputStream stream = new FileOutputStream(filePath);){
            ((OutputStream)stream).write(data);
        }
        return new File(filePath);
    }

    public static List<List<String>> readExcel(InputStream inputStream) throws IOException {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        XSSFSheet sheet = workbook.getSheetAt(0);
        int countBlankRow = 0;
        for (Row row : sheet) {
            if (countBlankRow > 5) break;
            ArrayList<String> rowItem = new ArrayList<String>();
            int lastCellNum = row.getLastCellNum();
            for (int i = 0; i < lastCellNum; ++i) {
                String valueItem = "";
                Cell cell = row.getCell(i);
                if (!DataUtil.isNullObject(cell)) {
                    CellType cellType = cell.getCellType();
                    switch (cellType) {
                        case _NONE: 
                        case ERROR: {
                            break;
                        }
                        case BOOLEAN: {
                            valueItem = String.valueOf(cell.getBooleanCellValue());
                            break;
                        }
                        case BLANK: {
                            break;
                        }
                        case FORMULA: {
                            XSSFFormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
                            valueItem = String.valueOf(evaluator.evaluate(cell).getNumberValue());
                            break;
                        }
                        case NUMERIC: {
                            valueItem = NumberToTextConverter.toText((double)cell.getNumericCellValue());
                            break;
                        }
                        case STRING: {
                            valueItem = cell.getStringCellValue();
                        }
                    }
                }
                rowItem.add(valueItem);
            }
            boolean isAllItemBlank = CollectionUtil.isAllItemBlank(rowItem);
            if (isAllItemBlank) {
                ++countBlankRow;
                continue;
            }
            countBlankRow = 0;
            result.add(rowItem);
        }
        return result;
    }

    public static <T> List<T> readExcel(InputStream inputStream, Class<T> targetClass, int startRow, String dateFormat) throws IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        ArrayList<T> result = new ArrayList<T>();
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        XSSFSheet sheet = workbook.getSheetAt(0);
        int lastRowNum = sheet.getLastRowNum();
        int countBlankRow = 0;
        for (int i = startRow; i <= lastRowNum && countBlankRow <= 5; ++i) {
            XSSFRow row = sheet.getRow(i);
            ArrayList<String> rowItem = new ArrayList<String>();
            int lastCellNum = row.getLastCellNum();
            for (int j = 0; j < lastCellNum; ++j) {
                String valueItem = "";
                Cell cell = row.getCell(j);
                if (!DataUtil.isNullObject(cell)) {
                    CellType cellType = cell.getCellType();
                    switch (cellType) {
                        case _NONE: 
                        case ERROR: {
                            break;
                        }
                        case BOOLEAN: {
                            valueItem = String.valueOf(cell.getBooleanCellValue());
                            break;
                        }
                        case BLANK: {
                            break;
                        }
                        case FORMULA: {
                            XSSFFormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
                            valueItem = String.valueOf(evaluator.evaluate(cell).getNumberValue());
                            break;
                        }
                        case NUMERIC: {
                            valueItem = NumberToTextConverter.toText((double)cell.getNumericCellValue());
                            break;
                        }
                        case STRING: {
                            valueItem = cell.getStringCellValue();
                        }
                    }
                }
                rowItem.add(valueItem);
            }
            boolean isAllItemBlank = CollectionUtil.isAllItemBlank(rowItem);
            if (isAllItemBlank) {
                ++countBlankRow;
                continue;
            }
            countBlankRow = 0;
            T resultItem = DataUtil.listToObject(rowItem, targetClass, dateFormat);
            result.add(resultItem);
        }
        return result;
    }

    public static String writeExcel(List<List<String>> data) throws IOException {
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            Sheet sheet = workbook.createSheet();
            int rowCount = 0;
            for (List<String> rowData : data) {
                Row row = sheet.createRow(rowCount++);
                int columnCount = 0;
                for (String str : rowData) {
                    row.createCell(columnCount++).setCellValue(str);
                }
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outputStream);
            byte[] bytes = outputStream.toByteArray();
            String string = DataUtil.encodesBase64(bytes);
            return string;
        }
    }

    public static <T> String writeExcel(List<T> data, String dateFormat) throws IOException, IllegalAccessException {
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            Sheet sheet = workbook.createSheet();
            int rowCount = 0;
            for (T rowData : data) {
                List<String> rowDataStr = DataUtil.objectToList(rowData, dateFormat);
                Row row = sheet.createRow(rowCount++);
                int columnCount = 0;
                for (String str : rowDataStr) {
                    row.createCell(columnCount++).setCellValue(str);
                }
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outputStream);
            byte[] bytes = outputStream.toByteArray();
            String string = DataUtil.encodesBase64(bytes);
            return string;
        }
    }

    public static <T> String writeExcel(List<T> data, List<String> header, String dateFormat) throws IOException, IllegalAccessException {
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            Sheet sheet = workbook.createSheet();
            int rowCount = 1;
            Row row = sheet.createRow(rowCount++);
            int columnCount = 0;
            for (String str : header) {
                row.createCell(columnCount++).setCellValue(str);
            }
            for (String rowData : data) {
                List<String> rowDataStr = DataUtil.objectToList(rowData, dateFormat);
                row = sheet.createRow(rowCount++);
                columnCount = 0;
                for (String str : rowDataStr) {
                    row.createCell(columnCount++).setCellValue(str);
                }
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outputStream);
            byte[] bytes = outputStream.toByteArray();
            String string = DataUtil.encodesBase64(bytes);
            return string;
        }
    }

    public static String getBase64FromImageURL(String url) {
        try {
            int read;
            URL imageUrl = new URL(url);
            URLConnection ucon = imageUrl.openConnection();
            InputStream is = ucon.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((read = is.read(buffer, 0, buffer.length)) != -1) {
                baos.write(buffer, 0, read);
            }
            baos.flush();
            return DataUtil.encodesBase64(baos.toByteArray());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getBase64FromImage(BufferedImage image, String type) {
        return "data:image/" + type + ";base64," + FileUtil.encodeToString(image, type);
    }

    public static String getBase64FromFilePath(String filePath) {
        try {
            File file = new File(filePath);
            return FileUtil.getBase64FromFile(file);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public static String getBase64FromFile(File file) {
        try {
            byte[] encoded = org.apache.commons.codec.binary.Base64.encodeBase64((byte[])FileUtils.readFileToByteArray((File)file));
            return new String(encoded, StandardCharsets.US_ASCII);
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public static String encodeToString(BufferedImage image, String type) {
        String imgStr = "";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, type, bos);
            byte[] imageBytes = bos.toByteArray();
            imgStr = org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])imageBytes);
            bos.close();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return imgStr;
    }

    public static ByteArrayOutputStream docToPdf(String docFilePath) {
        File pdfFile = File.createTempFile(DataUtil.safeToString(System.currentTimeMillis()), ".pdf");
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(docFilePath));
        IConverter converter = ((LocalConverter.Builder)((LocalConverter.Builder)LocalConverter.builder().baseFolder(new File(System.getProperty("java.io.tmpdir")))).workerPool(20, 25, 2L, TimeUnit.SECONDS)).processTimeout(5L, TimeUnit.SECONDS).build();
        Future conversion = converter.convert((InputStream)in).as(DocumentType.MS_WORD).to((OutputStream)bo).as(DocumentType.PDF).prioritizeWith(1000).schedule();
        conversion.get();
        try (FileOutputStream outputStream = new FileOutputStream(pdfFile);){
            bo.writeTo(outputStream);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        ((InputStream)in).close();
        bo.close();
        return bo;
    }

    public static void main(String[] args) {
        FileUtil.docToPdf("D:\\test\\rpt_doc_4404208543775647183_171896382576611587534932547323790.docx");
    }
}

