/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.anhtd081095.util;

import io.gitlab.anhtd081095.util.DataUtil;
import io.gitlab.anhtd081095.util.Singleton;
import java.util.Map;
import javax.script.ScriptEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MathUtil {
    private static final Logger log = LogManager.getLogger(MathUtil.class);
    private static final String FORMULA_PREFIX = "^F:";

    public static void main(String[] args) {
        String formula = "F:<level>/5";
        MathUtil.isFormula(formula);
        MathUtil.validFormulaFormat(formula);
        System.out.println(1);
    }

    public static Boolean isFormula(String formula) {
        if (DataUtil.isNullOrEmpty(formula)) {
            return false;
        }
        return formula.matches(FORMULA_PREFIX);
    }

    public static Boolean validFormulaFormat(String formula) {
        try {
            formula = formula.replace(FORMULA_PREFIX, "").replaceAll("<\\w+>", "1");
            ScriptEngine engine = Singleton.getScriptEngine();
            engine.eval(formula);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Double calculateByPattern(String pattern, Map<String, Object> data) {
        try {
            String calculation = DataUtil.setParameters(pattern, data, 0);
            ScriptEngine engine = Singleton.getScriptEngine();
            Object result = engine.eval(calculation);
            return DataUtil.safeToDouble(result.toString());
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return 0.0;
        }
    }
}

