package ru.casperix.light_ui

import ru.casperix.light_ui.node.ElementContext
import ru.casperix.light_ui.node.NodeCollector
import ru.casperix.math.collection.getLooped
import ru.casperix.math.color.Colors
import ru.casperix.math.geometry.grow
import ru.casperix.renderer.Renderer2D
import kotlin.time.Duration

object DebugRender {
    enum class DebugLayer {
        CONTENT,
        VIEWPORT,
        HIERARCHY_PRIMARY,
        HIERARCHY_SECONDARY
    }



    fun debugRender(renderer: Renderer2D, sceneTime: Duration, collector: NodeCollector) {
        if (StageConfig.debugViewports) {
            collector.elementList.forEach {
                debugRender(renderer, sceneTime, it, collector.maxDepth, DebugLayer.VIEWPORT)
            }
        }
        if (StageConfig.debugContents) {
            collector.elementList.forEach {
                debugRender(renderer, sceneTime, it, collector.maxDepth, DebugLayer.CONTENT)
            }
        }
        if (StageConfig.debugHierarchy) {
            collector.elementList.forEach {
                debugRender(renderer, sceneTime, it, collector.maxDepth, DebugLayer.HIERARCHY_PRIMARY)
            }
            collector.elementList.forEach {
                debugRender(renderer, sceneTime, it, collector.maxDepth, DebugLayer.HIERARCHY_SECONDARY)
            }
        }
    }

    private fun debugRender(renderer: Renderer2D, sceneTime: Duration, context: ElementContext, maxDepth: Int, layer: DebugLayer) {
        val color = StageConfig.COLORS.getLooped(context.depth)
        val actualDepth = (sceneTime.inWholeMilliseconds / 500L).toInt() % (maxDepth + 1) == context.depth

        when (layer) {
            DebugLayer.HIERARCHY_PRIMARY -> if (actualDepth) {
                renderer.drawQuadContour(Colors.BLACK.setAlpha(0.7f), context.worldShape.grow(4f), 8f)
            }

            DebugLayer.HIERARCHY_SECONDARY -> if (actualDepth) {
                renderer.drawQuad(color.setAlpha(0.7f), context.worldShape)
            }

            DebugLayer.CONTENT -> {
//                renderer.drawQuadContour(Colors.BLACK, context.contentShape.grow(1f), 1f)
                renderer.drawQuadContour(color, context.contentShape, 2f)
            }

            DebugLayer.VIEWPORT -> {
//                renderer.drawQuadContour(Colors.BLACK, context.worldShape.grow(1f), 1f)
                renderer.drawQuadContour(color, context.worldShape, 2f)
            }
        }
    }
}