package ru.casperix.light_ui.component

import ru.casperix.light_ui.component.button.ToggleButton
import ru.casperix.light_ui.layout.orientation_layout.OrientationLayout
import ru.casperix.light_ui.node.Node
import ru.casperix.light_ui.types.Orientation
import ru.casperix.renderer.misc.AlignMode
import ru.casperix.light_ui.element.*
import ru.casperix.light_ui.layout.Layout
import ru.casperix.light_ui.layout.LayoutSide


class Tab(val button: ToggleButton, val content: Element) {
    constructor(label: String, content: Element) : this(ToggleButton(label), content)
}

class TabMenu(primarySide: LayoutSide, tabs: List<Tab>) : AbstractElement(SizeMode.content), AbstractContainer {
    private val buttonOrientation = when (primarySide) {
        LayoutSide.LEFT, LayoutSide.RIGHT -> Orientation.VERTICAL
        LayoutSide.TOP, LayoutSide.BOTTOM -> Orientation.HORIZONTAL
    }

    private val tabNode = Node(createToggleGroup(calculateTabsLayout(), ToggleGroupSelectionMode.ALWAYS_ONE, tabs.map { it.button }))
    private fun calculateTabsLayout(): Layout {
        return if (buttonOrientation == Orientation.VERTICAL) {
            Layout.VERTICAL
        } else {
            Layout.HORIZONTAL
        }
    }


    private val contentNode = Node(Empty())

    override val layout = OrientationLayout(buttonOrientation.rotate(), AlignMode.LEFT_TOP)

    override val children = listOf(
        tabNode,
        contentNode,
    ).run {
        if (primarySide == LayoutSide.BOTTOM || primarySide == LayoutSide.RIGHT) {
            asReversed()
        } else {
            this
        }
    }

    init {
        tabs.map {
            it.button.clickEvent.then {
                setContent(it.content)
            }
        }
        tabs.forEach {
            if (it.button.isChecked) {
                setContent(it.content)
            }
        }
    }

    private fun setContent(content: Element) {
        this.contentNode.element = content
//        content.placement.sizeMode = SizeMode.min
    }
}