package ru.casperix.light_ui.component

import ru.casperix.light_ui.component.button.ToggleButton
import ru.casperix.light_ui.component.panel.QuadGraphic
import ru.casperix.light_ui.skin.SkinProvider
import ru.casperix.light_ui.layout.Layout
import ru.casperix.light_ui.element.DrawableContainer
import ru.casperix.light_ui.node.Node

enum class ToggleGroupSelectionMode {
    ALWAYS_ONE,
    MAX_ONE,
}

fun createToggleGroup(layout: Layout, mode: ToggleGroupSelectionMode, vararg children: ToggleButton): DrawableContainer {
    return createToggleGroup(layout, mode, children.toList())
}

fun createToggleGroup(layout: Layout, mode: ToggleGroupSelectionMode, children: List<ToggleButton>): DrawableContainer {
    ToggleGroupController(mode, children)
    return DrawableContainer(layout, children.map(::Node), QuadGraphic(SkinProvider.skin.panelDefault))
}


class ToggleGroupController(val mode: ToggleGroupSelectionMode, val buttons: List<ToggleButton>) {
    private var selfClick = false

    init {
        buttons.map {
            it.clickEvent.then {
                buttonClick(it)
            }
        }

        val checkCandidate = buttons.firstOrNull { it.isChecked } ?: buttons.firstOrNull()
        if (checkCandidate != null) {
            checkCandidate.isChecked = true
            validateCheck(checkCandidate)
        }
    }

    private fun buttonClick(self: ToggleButton) {
        if (selfClick) return

        selfClick = true
        validateCheck(self)
        selfClick = false
    }

    private fun validateCheck(initiator: ToggleButton) {
        if (initiator.isChecked) {
            buttons.forEach {
                it.isChecked = it == initiator
            }
        } else {
            buttons.forEach {
                it.isChecked = it == initiator && mode == ToggleGroupSelectionMode.ALWAYS_ONE
            }
        }
    }
}
