package ru.casperix.light_ui.component.button

import ru.casperix.light_ui.component.button.graphic.ToggleButtonGraphic
import ru.casperix.light_ui.component.text.Label
import ru.casperix.light_ui.element.SizeMode
import ru.casperix.light_ui.element.setSizeMode
import ru.casperix.light_ui.node.Node
import ru.casperix.light_ui.skin.SkinProvider
import kotlin.reflect.KMutableProperty0

class ToggleButton(
    val label: Label,
    isChecked: Boolean = true,
    skin: ToggleButtonSkin = SkinProvider.skin.toggleButton,
    handler: (ToggleButton.() -> Unit)? = null,
) : AbstractButton<ToggleButtonSkin>(skin) {
    constructor(
        text: String = "",
        isChecked: Boolean = true,
        skin: ToggleButtonSkin = SkinProvider.skin.toggleButton,
        handler: (ToggleButton.() -> Unit)? = null,
    ) : this(
        Label(text),
        isChecked,
        skin,
        handler,
    )

    constructor(
        label: String, property: KMutableProperty0<Boolean>, skin: ToggleButtonSkin = SkinProvider.skin.toggleButton,
    )
            : this(label, property.get(), skin, {
        property.set(isChecked)
    })


    override val drawer = ToggleButtonGraphic(skin, state)
    override val children = listOf(Node(label))

    var isChecked
        get() = state.checked
        set(value) {
            if (value != state.checked) {
                click()
            }
        }

    init {
        label.setSizeMode(SizeMode.view)
        setListener(handler)
        skinChanged.set(skin)
        this.isChecked = isChecked
    }

    fun setLabel(text: String) = apply {
        label.text = text
    }

    fun setListener(isChecked: Boolean = true, handler: ToggleButton.() -> Unit) = apply {
        this.isChecked = isChecked
        clickEvent.then { handler(this) }
    }

    fun setListener(property: KMutableProperty0<Boolean>) = apply {
        setListener(property.get()) { property.set(isChecked) }
    }

    fun setCheckedListener(isChecked: Boolean = true, handler: ToggleButton.() -> Unit) = apply {
        this.isChecked = isChecked
        clickEvent.then { if (state.checked) handler(this) }
    }
}