package ru.casperix.light_ui.component.scroll

import ru.casperix.light_ui.element.ElementDrawer
import ru.casperix.light_ui.node.DrawContext
import ru.casperix.math.color.Color
import ru.casperix.math.geometry.grow
import ru.casperix.renderer.Renderer2D
import kotlin.time.Duration

class ScrollBoxGraphic(val color: Color) : ElementDrawer {

    override fun draw(renderer: Renderer2D, context: DrawContext, tick: Duration) {
        val worldShape = context.worldShape

        renderer.drawQuadContour(color, worldShape.grow(-2f), 6f)
    }

}