package ru.casperix.light_ui.component.spine

import ru.casperix.light_ui.node.DrawContext
import ru.casperix.math.axis_aligned.float32.Box2f
import ru.casperix.math.quad_matrix.float32.Matrix3f
import ru.casperix.math.vector.float32.Vector2f
import ru.casperix.misc.toFloat
import ru.casperix.renderer.Renderer2D
import ru.casperix.renderer.misc.AlignMode
import ru.casperix.light_ui.element.*
import ru.casperix.spine.AnimationState
import ru.casperix.spine.Skeleton
import ru.casperix.spine.renderer.SkeletonRenderer.drawSkeleton
import ru.casperix.spine.renderer.SkeletonRenderer.drawSkeletonDebug
import kotlin.time.Duration
import kotlin.time.DurationUnit


class Spine(val skeleton: Skeleton, var animationState: AnimationState) : Element, ElementDrawer {
    override val placement = ElementPlacement(SizeMode.view)
    override val drawer = this
    override val input: ElementInput? = null
    override var update: ElementUpdate? = null
    override var tag: String = ""

    var align = AlignMode.CENTER_BOTTOM
    var scale = 1f
    var debug = false
    var speed = 1f

    override fun draw(renderer: Renderer2D, context: DrawContext, tick: Duration) {
        val v0 = context.worldShape.v0
        val v2 = context.worldShape.v2
        val box = Box2f.byCorners(v0, v2)
        val pivot = box.min + align.getPosition(box.dimension, Vector2f.ZERO)

        animationState.nextFrame(skeleton, tick.toFloat(DurationUnit.SECONDS) * speed)
        skeleton.parentMatrix = Matrix3f.scale(Vector2f(scale, scale)) * Matrix3f.translate(pivot)

        renderer.drawSkeleton(skeleton)
        if (debug) {
            renderer.drawSkeletonDebug(skeleton)
        }
    }
}

