package ru.casperix.light_ui.component.text

import ru.casperix.light_ui.component.panel.QuadGraphic
import ru.casperix.light_ui.element.ElementDrawer
import ru.casperix.light_ui.element.ElementWithLayout
import ru.casperix.light_ui.layout.common.LayoutHelper
import ru.casperix.light_ui.node.DrawContext
import ru.casperix.light_ui.skin.SkinProvider
import ru.casperix.multiplatform.text.impl.TextLayoutRender.drawTextLayoutMetrics
import ru.casperix.multiplatform.text.textRenderer
import ru.casperix.renderer.Renderer2D
import ru.casperix.renderer.misc.AlignMode
import kotlin.time.Duration

class Label(var text: String = "", skin: LabelSkin = SkinProvider.skin.label, val alignMode: AlignMode = AlignMode.CENTER_CENTER) : ElementDrawer,
    SkinnedElement<LabelSkin>(skin), ElementWithLayout {

    override val drawer = this

    private val layoutBuilder = TextLayoutBuilder()

    init {
        placement.borders = skin.borders
    }

    override fun invalidateLayout() {
        layoutBuilder.text = text
        layoutBuilder.viewportSize = placement.viewportSize
        layoutBuilder.font = skin.font
        layoutBuilder.alignMode = alignMode
        val layout = layoutBuilder.layout
        placement.contentArea = LayoutHelper.calculateSize(layout.getArea())
    }

    override fun draw(renderer: Renderer2D, context: DrawContext, tick: Duration): Unit = context.run {
        skin.back?.let {
            QuadGraphic(it).draw(renderer, context, tick)
        }

        val layout = layoutBuilder.layout

        textRenderer.drawTextLayout(renderer, worldMatrix, skin.color, layout)

        if (skin.drawTextMetrics) {
            val pixelFont = textRenderer.getPixelFont(skin.font)
            drawTextLayoutMetrics(renderer, worldMatrix, pixelFont, layout)
        }
    }


}

