package ru.casperix.light_ui.component.text

import ru.casperix.math.vector.float32.Vector2f
import ru.casperix.multiplatform.font.FontReference
import ru.casperix.multiplatform.text.TextLayout
import ru.casperix.multiplatform.text.textRenderer
import ru.casperix.renderer.misc.AlignMode

object TextHelper {
    fun applyAlign(layout: TextLayout, availableArea: Vector2f, alignMode: AlignMode): TextLayout {
        val alignOffset = alignMode.getPosition(availableArea, layout.getArea().dimension)

        return layout.copy(symbols = layout.symbols.map {
            it.copy(pivot = it.pivot + alignOffset)
        })
    }

    fun calculateLayout(text: String, viewportSize: Vector2f, font: FontReference, alignMode: AlignMode): TextLayout {
        val layout = textRenderer.createTextLayout(text, viewportSize, font)
        return applyAlign(layout, viewportSize, alignMode)
    }
}