package ru.casperix.light_ui.component.text

import ru.casperix.light_ui.skin.SkinProvider
import ru.casperix.light_ui.util.DelegatesExt
import ru.casperix.math.vector.float32.Vector2f
import ru.casperix.multiplatform.font.FontReference
import ru.casperix.multiplatform.text.TextLayout
import ru.casperix.renderer.misc.AlignMode

class TextLayoutBuilder() {
    private var dirty = true

    var text: String by DelegatesExt.observableChange("") { invalidateLayout() }
    var viewportSize: Vector2f by DelegatesExt.observableChange(Vector2f.ZERO) { invalidateLayout() }
    var font: FontReference by DelegatesExt.observableChange(SkinProvider.skin.defaultFont) { invalidateLayout() }
    var alignMode: AlignMode by DelegatesExt.observableChange(AlignMode.CENTER_CENTER) { invalidateLayout() }

    var layout = TextLayout.EMPTY
        get() {
            if (dirty) {
                rebuildLayout()
            }
            return field
        }

    private fun rebuildLayout() {
        layout = TextHelper.calculateLayout(text, viewportSize, font, alignMode)
        dirty = false
    }

    private fun invalidateLayout() {
        dirty = true
    }
}