package ru.casperix.light_ui.component.text.editor

import ru.casperix.math.axis_aligned.float32.Box2f
import ru.casperix.math.vector.float32.Vector2f
import ru.casperix.multiplatform.text.TextLayout

object TextEditorHelper {

    val BACKSPACE = 8.toChar()
    val CARRIAGE_RETURN = '\r'
    val NEWLINE = '\n'
    val TAB = '\t'
    val DELETE = 127.toChar()
    val SPECIAL_SYMBOLS = listOf(BACKSPACE, CARRIAGE_RETURN, NEWLINE, TAB, DELETE)

    private val CURSOR_THICK = 2f

    fun getCursorArea(cursorIndex: Int, textLayout: TextLayout, lineHeight:Float, areaSize:Vector2f): Box2f? {
        val cursorBasis = Vector2f(CURSOR_THICK, 0f)

        if (textLayout.symbols.isEmpty()) {

            return Box2f.byDimension(
                areaSize / 2f - (cursorBasis + Vector2f(0f, lineHeight)) / 2f,
                cursorBasis + Vector2f(0f, lineHeight)
            )
        }

        return if (cursorIndex >= textLayout.symbols.size) {
            val nearArea = textLayout.symbols.last().area
            Box2f.byDimension(
                nearArea.min + nearArea.dimension.xAxis - cursorBasis / 2f,
                cursorBasis + nearArea.dimension.yAxis
            )
        } else {
            val nearArea = textLayout.symbols.get(cursorIndex).area
            Box2f.byDimension(nearArea.min - cursorBasis / 2f, cursorBasis + nearArea.dimension.yAxis)
        }
    }

    fun getNearIndex(textLayout: TextLayout, pointer: Vector2f): Int? {

        val near = textLayout.symbols.map {
            val area = it.area
            if (area.isInside(pointer)) {
                Pair(0f, it)
            } else {
                Pair(area.center.distTo(pointer), it)
            }
        }.minByOrNull { it.first }

        return if (near == null) {
            null
        } else {
            val index = textLayout.symbols.indexOf(near.second)
            val nearArea = near.second.area

            val leftSide = (nearArea.center.x > pointer.x)

            if (leftSide) {
                index
            } else {
                index + 1
            }
        }
    }
}