package ru.casperix.multiplatform.text

import ru.casperix.multiplatform.font.FontReference
import ru.casperix.multiplatform.font.pixel.PixelFont
import ru.casperix.math.color.Color
import ru.casperix.math.color.Colors
import ru.casperix.math.quad_matrix.float32.Matrix3f
import ru.casperix.math.vector.float32.Vector2f
import ru.casperix.renderer.Renderer2D


expect val textRenderer: TextRendererApi

fun Renderer2D.drawText(
    text: String,
    reference: FontReference,
    matrix: Matrix3f,
    availableArea: Vector2f = Vector2f(Float.POSITIVE_INFINITY),
    color: Color = Colors.WHITE,
    backgroundColor: Color? = null
): TextLayout {
    return textRenderer.drawText(this, text, reference, matrix, availableArea, color, backgroundColor)
}


fun Renderer2D.drawText(
    text: String,
    reference: FontReference,
    position: Vector2f,
    availableArea: Vector2f = Vector2f(Float.POSITIVE_INFINITY),
    color: Color = Colors.WHITE,
    backgroundColor: Color? = null
): TextLayout {
    return textRenderer.drawText(this, text, reference, Matrix3f.translate(position), availableArea, color, backgroundColor)
}

interface TextRendererApi {
    fun getPixelFont(reference: FontReference): PixelFont

    fun drawText(
        renderer: Renderer2D,
        text: String,
        reference: FontReference,
        matrix: Matrix3f,
        availableArea: Vector2f = Vector2f(100f),
        color: Color = Colors.WHITE,
        backgroundColor: Color? = null
    ): TextLayout

    fun createTextLayout(text: String, areaSize: Vector2f, font: PixelFont): TextLayout

    fun drawTextLayout(renderer: Renderer2D, matrix: Matrix3f, color: Color, layout: TextLayout)

    fun drawTextLayoutMetrics(renderer: Renderer2D, matrix: Matrix3f, font: FontReference, layout: TextLayout) {
        drawTextLayoutMetrics(renderer, matrix, getPixelFont(font), layout)
    }

    fun drawTextLayoutMetrics(renderer: Renderer2D, matrix: Matrix3f, font: PixelFont, layout: TextLayout)


    fun createTextLayout(text: String, areaSize: Vector2f, reference: FontReference): TextLayout {
        return createTextLayout(text, areaSize, getPixelFont(reference))
    }
}