package ru.casperix.multiplatform.loader

import ru.casperix.multiplatform.put
import ru.casperix.renderer.pixel_map.PixelMap
import java.awt.AlphaComposite
import java.awt.Transparency
import java.awt.color.ColorSpace
import java.awt.image.*

@ExperimentalUnsignedTypes
object JvmImageConverter {
    /**
     *
     *  @see <a href="https://stackoverflow.com/questions/65569243/getting-a-rgba-byte-array-from-a-bufferedimage-java">stackoverflow</a>
     */
    fun createPixelMap(image: BufferedImage, name:String): PixelMap {
        val bytes = getRGBA(image)
        return PixelMap.RGBA(image.width, image.height, bytes.toUByteArray(), name)
    }


    private fun getRGBA(image: BufferedImage): ByteArray {
        val colorModel = ComponentColorModel(
            ColorSpace.getInstance(ColorSpace.CS_sRGB),
            true,
            false,
            Transparency.TRANSLUCENT,
            DataBuffer.TYPE_BYTE
        )

        val raster = Raster.createInterleavedRaster(
            DataBuffer.TYPE_BYTE,
            image.width,
            image.height,
            image.width * 4,
            4,
            intArrayOf(0, 1, 2, 3),
            null
        ) // R, G, B, A order

        val imageRGBA = BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied, null)
        val bytesRGBA = (raster.dataBuffer as DataBufferByte).data

        // Draw the image onto the RGBA buffer, which will be updated immediately
        val g = imageRGBA.createGraphics()
        try {
            g.composite = AlphaComposite.Src
            g.drawImage(image, 0, 0, null)
        } finally {
            g.dispose()
        }
        return bytesRGBA
    }

    fun createBufferedImage(pixelMap: PixelMap): BufferedImage {
        val colorModel = ComponentColorModel(
            ColorSpace.getInstance(ColorSpace.CS_sRGB),
            true,
            false,
            Transparency.TRANSLUCENT,
            DataBuffer.TYPE_BYTE
        )

        val raster = Raster.createInterleavedRaster(
            DataBuffer.TYPE_BYTE,
            pixelMap.width,
            pixelMap.height,
            pixelMap.width * 4,
            4,
            intArrayOf(0, 1, 2, 3),
            null
        ) // R, G, B, A order

        val image = BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied, null)
        val imageBytes = (raster.dataBuffer as DataBufferByte).data
        if (imageBytes.size != pixelMap.bytes.size) {
            throw Exception("Invalid pixelmap size")
        }
        imageBytes.put(pixelMap.bytes.data.toByteArray(), 0)

        return image
    }
}