package ru.casperix.multiplatform.text

import ru.casperix.multiplatform.font.FontReference
import ru.casperix.multiplatform.font.pixel.PixelFont
import ru.casperix.multiplatform.text.impl.AbstractTextRenderer

actual val textRenderer : TextRendererApi = JvmTextRenderer()

class JvmTextRenderer : AbstractTextRenderer(), TextRendererApi {
    override fun buildFont(reference: FontReference, chars: Set<Char>): PixelFont {
        return PixelFontBuilder.build(reference, chars)
    }

}


//
//fun textLayout(font: JvmPixelFont, text: String): TextLayoutBuilder.TextLayout {
//
//    val frc = FontRenderContext(AffineTransform(), true, false)
//    val vector = font.awtFont.layoutGlyphVector(
//        frc,
//        text.toCharArray(),
//        0,
//        text.length,
//        Bidi.DIRECTION_DEFAULT_LEFT_TO_RIGHT
//    )
//
//    val glyphs = (0 until vector.numGlyphs).mapNotNull { glyphIndex ->
//        val char = text[glyphIndex]
//        val symbol = font.main.symbols[char]
//        if (symbol != null) {
//            val position = vector.getGlyphPosition(glyphIndex).toVector2f()
//            TextLayoutBuilder.GlyphInfo(position, char, symbol)
//        } else null
//    }
//    val area = vector.logicalBounds.toBox2f()
//    return TextLayoutBuilder.TextLayout(text, Box2f(Vector2f.ZERO, area.dimension.round()), glyphs)
//}
//
//
