package casperix.font

/**
 *
 * ---
 * /\
 * |
 * | ascent
 * |
 *\/
 * --- baseline (y = 0, grow-down)
 * /\
 * |
 * | descent
 *\/
 * ---
 * /\
 * | leading
 *\/
 * ---
 *
 */
data class FontMetrics(
    val ascent: Float,
    val descent: Float,
    val leading: Float
) {
    val textHeight = ascent + descent
    val lineHeight = ascent + descent + leading
}