package casperix.font.localize

object ChineseSimplifiedCharacters {
    private val symbols =
        "\u00A0\u00A7\u00A9\u00B7\u2030\u2035\u203B\u20AC\u4E03\u4E11\u4E16\u4E22\u4E27\u4E2A\u4E2D\u4E30\u4E32\u4E34\u4E43\u4E45\u4E54\u4E56\u4E5D\u4E66\u4E7E\u4E86\u4EA1\u4EAE\u4EB2\u4EBA\u4EC5\u4EC7\u4ED4\u4ED6\u4EEA\u4EEC\u4EF0\u4EF2\u4EFB\u4EFD\u4EFF\u4F01\u4F0A\u4F0D\u4F24\u4F26\u4F34\u4F38\u4F46\u4F53\u4F55\u4F59\u4F60\u4F64\u4F69\u4F73\u4F7F\u4F8B\u4F9B\u4F9D\u4FA0\u4FAC\u4FAF\u4FB5\u4FBF\u4FCA\u4FD7\u4FDD\u4FE1\u4FE9\u4FEE\u4FF1\u4FFE\u500D\u5012\u501F\u5026\u503C\u503E\u5047\u504C\u504F\u505A\u505C\u5065\u50A8\u50AC\u50B2\u50BB\u50CF\u50E7\u5112\u513F\u5141\u514B\u514D\u5151\u5154\u515A\u5165\u5168\u5185\u5188\u5192\u5199\u51A0\u51AC\u51B0\u51B5\u51B7\u51C6\u51CC\u51CF\u51DD\u51E4\u51ED\u51FD\u5200\u520A\u521D\u5224\u5229\u522B\u5230\u5242\u524D\u5251\u5267\u526F\u5272\u529B\u52A3\u52BF\u52C7\u52C9\u52CB\u52D2\u52E4\u5308\u5319\u5341\u5343\u534A\u535A\u536B\u5377\u5382\u5389\u539A\u539F\u53BB\u53BF\u53C2\u53D1\u53D4\u5413\u5417\u541B\u541D\u541F\u542F\u5435\u543B\u543E\u5440\u5446\u5448\u544A\u5450\u5458\u545C\u5462\u5466\u5468\u5473\u5475\u548C\u5496\u54AA\u54AC\u54AF\u54B1\u54DF\u54ED\u54F2\u5509\u5510\u5524\u552C\u5531\u5537\u5546\u554A\u5561\u556A\u5580\u5582\u5584\u5587\u558A\u558F\u5594\u55B5\u55B7\u55BB\u55D2\u55E8\u55EF\u5609\u561B\u5634\u563B\u563F\u5668\u56DB\u56DE\u56E0\u56E2\u56ED\u56F0\u56F4\u56FA\u5706\u5708\u571F\u5723\u5728\u572D\u5730\u5733\u573A\u573E\u5740\u5747\u574E\u5757\u5761\u5764\u5766\u576A\u578B\u5792\u57C3\u57CB\u57CE\u57D4\u57DF\u5802\u5806\u5815\u5821\u582A\u5851\u5854\u585E\u586B\u5883\u589E\u58A8\u58C1\u58E4\u58EE\u58F0\u5904\u5907\u590D\u590F\u591A\u591C\u591F\u5925\u5927\u592E\u5931\u5934\u594B\u594F\u5951\u5954\u5965\u5976\u5979\u597D\u5982\u5996\u5999\u59A5\u59A8\u59AE\u59B9\u59BB\u59C6\u59FF\u5A01\u5A18\u5A1C\u5A1F\u5A31\u5A46\u5A5A\u5A92\u5AC1\u5ACC\u5AE9\u5B50\u5B5F\u5B66\u5B69\u5B81\u5B83\u5B8F\u5BAA\u5BB6\u5BB9\u5BC2\u5BCC\u5BD2\u5BE1\u5BE8\u5BFF\u5C01\u5C04\u5C06\u5C0A\u5C0F\u5C11\u5C14\u5C16\u5C18\u5C1A\u5C1D\u5C24\u5C31\u5C3A\u5C45\u5C4B\u5C4F\u5C55\u5C5E\u5C60\u5C71\u5CB3\u5CB8" +
                "\u5CE1\u5CF0\u5D07\u5D29\u5D34\u5DE1\u5DEB\u5DEE\u5DF7\u5E05\u5E08\u5E0C\u5E10\u5E1D\u5E26\u5E38\u5E3D\u5E45\u5E55\u5E76\u5E78\u5E7F\u5E86\u5E8A\u5E8F\u5E97\u5E9C\u5EAD\u5EC9\u5ED6\u5EFA\u5F00\u5F0A\u5F0F\u5F15\u5F2F\u5F31\u5F55\u5F5D\u5F62\u5F69\u5F77\u5F79\u5F88\u5F90\u5F92\u5F97\u5FAA\u5FAE\u5FB5\u5FB7\u5FC3\u5FE0\u5FE7\u5FEB\u5FF5\u5FFD\u600E\u6012\u601D\u6021\u6025\u602A\u603B\u604B\u6050\u6062\u606D\u6076\u607C\u6084\u6089\u6094\u60A3\u60A8\u60B2\u60C5\u60D1\u60DC\u60E0\u60EF\u60F3\u60F9\u6101\u610F\u611A\u611F\u6127\u6148\u614E\u6155\u6162\u6167\u6170\u61BE\u61C2\u61D2\u6208\u620A\u620C\u6216\u6218\u622A\u6234\u6237\u6247\u624B\u6251\u6253\u6258\u6263\u6267\u6269\u6279\u6284\u628A\u6291\u6293\u6295\u62A2\u62B1\u62B5\u62B9\u62BD\u62C9\u62CD\u62D2\u62D4\u62D6\u62D8\u62DF\u62EC\u62F3\u62F7\u62FC\u6301\u6307\u6309\u6311\u6316\u631D\u6321\u632A\u632F\u633A\u6349\u6350\u6355\u635F\u636E\u6377\u638C\u6392\u63A2\u63A5\u63B8\u63D2\u63E1\u63F4\u641C\u641E\u6444\u6446\u644A\u6454\u6458\u6469\u6478\u6492\u649E\u64AD\u64E6\u652F\u6536\u6539\u653B\u6545\u6548\u654C\u654F\u6551\u6559\u655D\u6566\u656C\u6570\u6572\u6574\u6587\u658B\u6590\u6597\u6599\u659C\u65A5\u65AD\u65B9\u65C1\u65C5\u65CB\u65CF\u65D7\u65E0\u65E2\u65ED\u65F6\u65FA\u6602\u6606\u660C\u6613\u6625\u6628\u662D\u662F\u663E\u6643\u664B\u665A\u6668\u6674\u6676\u667A\u6682\u6691\u66AE\u66B4\u66F0\u66F2\u66F4\u66F9\u66FC\u670B\u670D\u6717\u671B\u671D\u671F\u6728\u672F\u6731\u6735\u673A\u6740\u6749\u674E\u675C\u675F\u6761\u6765\u6768\u6781\u6784\u6790\u6797\u67A2\u67B6\u67E5\u67EC\u67EF\u6807\u680B\u680F\u6811\u6821\u683C\u6843\u6846\u6848\u684C\u6851\u6863\u6865\u6881\u6885\u68A6\u68B5\u68C0\u68C9\u68CB\u68D2\u68DA\u68EE\u6905\u690D\u6930\u695A\u697C\u6982\u699C\u6A21\u6A31\u6A80\u6B27\u6B32\u6B3A\u6B3E\u6B49\u6B4C\u6B6A\u6B7B\u6BB5\u6BC5\u6BCD\u6BCF\u6BD2\u6BDB\u6BEB\u6C0F\u6C11\u6C14\u6C1B\u6C34\u6C38\u6C42\u6C47\u6C49\u6C57\u6C5D\u6C64\u6C6A\u6C76\u6C7D\u6C83\u6C99\u6C9F\u6CA1\u6CA7\u6CB3\u6CB9\u6CBB\u6CBF\u6CD5\u6CDB\u6CE5\u6CE8\u6CF0\u6CF3\u6CFD\u6D0B\u6D17\u6D1B\u6D1E\u6D25\u6D2A\u6D32\u6D3B" +
                "\u6D41\u6D45\u6D4B\u6D51\u6D53\u6D59\u6D66\u6D6E\u6D74\u6D77\u6D85\u6D9B\u6DA8\u6DAF\u6DB2\u6DB5\u6DCB\u6DD1\u6DD8\u6DE1\u6DF1\u6DF7\u6DFB\u6E05\u6E10\u6E21\u6E23\u6E29\u6E2F\u6E34\u6E38\u6E56\u6E7E\u6E90\u6E9C\u6EAA\u6ECB\u6ED1\u6EE1\u6EE5\u6EE8\u6EF4\u6F02\u6F0F\u6F14\u6F20\u6F2B\u6F58\u6F5C\u6F6E\u6F8E\u6FB3\u6FC0\u704C\u706B\u706D\u7075\u707F\u7089\u708E\u70AE\u70C2\u70C8\u70E4\u70ED\u7126\u7136\u714C\u715E\u7167\u716E\u718A\u719F\u71C3\u71D5\u7206\u722A\u722C\u7231\u723D\u724C\u7259\u725B\u7267\u7269\u7272\u7275\u72AF\u72B6\u72B9\u72C2\u72D0\u72D7\u72E0\u72EC\u72EE\u72F1\u72FC\u732A\u732E\u7334\u7384\u7387\u7389\u738B\u739B\u73A9\u73AB\u73B2\u73BB\u73C0\u73CA\u73CD\u73E0\u73ED\u7403\u7406\u740A\u742A\u743C\u7459\u745C\u7470\u7476\u7483\u74DC\u74E6\u74F6\u7518\u751A\u751C\u751F\u7528\u7535\u753B\u7545\u754C\u7559\u7565\u756A\u7586\u758F\u7591\u7597\u75AF\u75B2\u75BC\u75BE\u75C5\u75D5\u75DB\u75F4\u7678\u767B\u7684\u76AE\u76C8\u76CA\u76D6\u76D8\u76DB\u76DF\u76EE\u76F4\u76F8\u76FC\u76FE\u7701\u7709\u770B\u773C\u7740\u775B\u7761\u7763\u77A7\u77DB\u77E3\u77E5\u77ED\u77F3\u77F6\u780D\u7814\u7834\u7840\u7855\u786C\u786E\u7897\u789F\u78A7\u78B0\u78C1\u78C5\u78E8\u793A\u793C\u793E\u7956\u795A\u7965\u7968\u796F\u7978\u7981\u7985\u798F\u79BB\u79CB\u79CD\u79D8\u79DF\u79E4\u79E6\u79E9\u79FB\u7A00\u7A0B\u7A23\u7A33\u7A3F\u7A46\u7A7F\u7A81\u7A97\u7A9D\u7ACB\u7AD9\u7AE5\u7AEF\u7AF9\u7B11\u7B14\u7B1B\u7B26\u7B28\u7B2C\u7B49\u7B4B\u7B51\u7B54\u7B56\u7B79\u7B7E\u7B80\u7B97\u7BA1\u7BAD\u7BB1\u7BC7\u7BEE\u7C3F\u7C4D\u7C73\u7C7B\u7C89\u7C92\u7C97\u7CA4\u7CB9\u7CBE\u7CCA\u7CDF\u7CFB\u7D20\u7D22\u7D27\u7D2B\u7D2F\u7E41\u7EA2\u7EAA\u7EAF\u7EB5\u7EBD\u7EBF\u7ECD\u7ECF\u7ED3\u7ED5\u7EDF\u7EE7\u7EED\u7EFC\u7EFF\u7F05\u7F13\u7F16\u7F18\u7F20\u7F29\u7F34\u7F36\u7F38\u7F3A\u7F55\u7F57\u7F5A\u7F62\u7F6A\u7F6E\u7F72\u7F8A\u7F8E\u7F9E\u7FA4\u7FAF\u7FBD\u7FC1\u7FC5\u7FD4\u7FD8\u7FE0\u7FF0\u8003\u8005\u8010\u8017\u8033\u8036\u804A\u804C\u8054\u8058\u805A\u806A\u8089\u8096\u809A\u80A1\u80A9\u80AF\u80B2\u80C1\u80C6\u80CC\u80CE\u80D6\u80DC\u80DE\u80E1\u80F6\u80F8\u80FD\u8106\u8111" +
                "\u8131\u8138\u814A\u8150\u8153\u8170\u8179\u81C2\u81E3\u81EA\u81ED\u8212\u822A\u822C\u8230\u8239\u826F\u8272\u827A\u827E\u8282\u8292\u829D\u82A6\u82B1\u82B3\u82CD\u82CF\u82D7\u82F1\u8328\u832B\u8336\u8349\u8350\u8352\u8363\u836F\u8377\u8389\u838E\u83B7\u83DC\u83E9\u83F2\u8404\u840D\u843D\u8457\u845B\u8461\u8482\u848B\u8499\u84C9\u84DD\u84EC\u8511\u8521\u8584\u85AA\u85C9\u85CF\u85E4\u864E\u8651\u866B\u8679\u8681\u86C7\u86CB\u86D9\u86EE\u8702\u871C\u8776\u878D\u87F9\u8822\u8840\u884C\u8857\u8861\u8863\u8865\u8868\u888B\u88AB\u88AD\u88C5\u88D5\u88E4\u897F\u8981\u8986\u89C4\u89C6\u89D2\u89E3\u8A00\u8A89\u8A93\u8B66\u8BA4\u8BB2\u8BBA\u8BC1\u8BC4\u8BC6\u8BC9\u8BCD\u8BD1\u8BD5\u8BD7\u8BDA\u8BE2\u8BED\u8BEF\u8BF4\u8BFE\u8C01\u8C03\u8C05\u8C08\u8C13\u8C1C\u8C22\u8C28\u8C31\u8C37\u8C46\u8C61\u8C6A\u8C8C\u8D2D\u8D2F\u8D31\u8D3C\u8D3E\u8D44\u8D54\u8D56\u8D5E\u8D60\u8D62\u8D64\u8D6B\u8D70\u8D75\u8D77\u8D81\u8D85\u8DA3\u8DB3\u8DC3\u8DCC\u8DD1\u8DDD\u8DDF\u8DEF\u8DF3\u8E0F\u8E22\u8E29\u8EAB\u8EB2\u8F66\u8F6C\u8F7B\u8F7D\u8F83\u8F91\u8F93\u8F9B\u8F9E\u8FB9\u8FBE\u8FC1\u8FC5\u8FCE\u8FD4\u8FE6\u8FF0\u8FF7\u8FFD\u9006\u9012\u9014\u901D\u9022\u9038\u9047\u904D\u9053\u9057\u9075\u9093\u90A3\u90A6\u90AA\u90AE\u90B1\u90BB\u90CE\u90D1\u90E8\u90ED\u90FD\u9102\u9149\u914B\u914D\u9152\u9189\u9192\u91C7\u91CA\u91D1\u9488\u9493\u949F\u94A2\u94A6\u94B1\u94BB\u94C1\u94C3\u94DC\u94E2\u94ED\u94F6\u94FA\u94FE\u9505\u950B\u9519\u9521\u9526\u952E\u953A\u9547\u955C\u956D\u957F\u95E8\u95EA\u95F0\u95F2\u95F4\u95F7\u95F9\u95FB\u9601\u9605\u9610\u9614\u961F\u962E\u963B\u9648\u964D\u9650\u9662\u9664\u9686\u9694\u969C\u96BE\u96C9\u96E8\u96EA\u96EF\u96F3\u96FE\u9700\u9707\u970D\u9716\u9732\u9752\u9756\u9759\u975E\u9760\u9762\u9769\u977C\u978B\u9791\u97E6\u97E9\u97F3\u9884\u9891\u989D\u98CE\u9910\u997C\u9986\u9996\u9999\u99A8\u9A6C\u9A71\u9A76\u9A7B\u9A7E\u9A8C\u9A91\u9A97\u9A9A\u9AA4\u9AA8\u9AD8\u9B3C\u9B42\u9B45\u9B54\u9C7C\u9C81\u9C9C\u9E1F\u9E21\u9E23\u9E2D\u9E3F\u9E45\u9E64\u9E70\u9E7F\u9EA6\u9EBB\u9EC4\u9ECE\u9ED1\u9ED8\u9F13\u9F20\u9F3B\u9F50\u9F7F\u9F84\u9F99\u9F9F\uFE63\uFE68\uFF3F\uFF5B\uFF5D"

    private val ranges = listOf(
        '\u0020'..'\u005F',
        '\u007B'..'\u007D',
        '\u2010'..'\u2011',
        '\u2013'..'\u2016',
        '\u2018'..'\u2019',
        '\u201C'..'\u201D',
        '\u2025'..'\u2026',
        '\u2032'..'\u2033',
        '\u3001'..'\u3003',
        '\u3007'..'\u3011',
        '\u3014'..'\u3017',
        '\u301D'..'\u301E',
        '\u4E00'..'\u4E01',
        '\u4E07'..'\u4E0E',
        '\u4E13'..'\u4E14',
        '\u4E18'..'\u4E1A',
        '\u4E1C'..'\u4E1D',
        '\u4E24'..'\u4E25',
        '\u4E38'..'\u4E3B',
        '\u4E3D'..'\u4E3E',
        '\u4E48'..'\u4E49',
        '\u4E4B'..'\u4E50',
        '\u4E58'..'\u4E59',
        '\u4E5F'..'\u4E61',
        '\u4E70'..'\u4E71',
        '\u4E88'..'\u4E89',
        '\u4E8B'..'\u4E8C',
        '\u4E8E'..'\u4E8F',
        '\u4E91'..'\u4E92',
        '\u4E94'..'\u4E95',
        '\u4E9A'..'\u4E9B',
        '\u4EA4'..'\u4EA8',
        '\u4EAB'..'\u4EAC',
        '\u4EBF'..'\u4EC1',
        '\u4ECA'..'\u4ECB',
        '\u4ECD'..'\u4ECE',
        '\u4ED8'..'\u4ED9',
        '\u4EE3'..'\u4EE5',
        '\u4EF6'..'\u4EF7',
        '\u4F0F'..'\u4F11',
        '\u4F17'..'\u4F1A',
        '\u4F1F'..'\u4F20',
        '\u4F2F'..'\u4F30',
        '\u4F3C'..'\u4F3D',
        '\u4F4D'..'\u4F51',
        '\u4F5B'..'\u4F5C',
        '\u4FA6'..'\u4FA8',
        '\u4FC3'..'\u4FC4',
        '\u5019'..'\u501A',
        '\u5076'..'\u5077',
        '\u5143'..'\u5146',
        '\u5148'..'\u5149',
        '\u516B'..'\u516E',
        '\u5170'..'\u5171',
        '\u5173'..'\u5179',
        '\u517B'..'\u517D',
        '\u518C'..'\u518D',
        '\u519B'..'\u519C',
        '\u51B2'..'\u51B3',
        '\u51E0'..'\u51E1',
        '\u51EF'..'\u51F0',
        '\u51FA'..'\u51FB',
        '\u5206'..'\u5207',
        '\u5211'..'\u5212',
        '\u5217'..'\u521B',
        '\u5236'..'\u5238',
        '\u523A'..'\u523B',
        '\u5269'..'\u526A',
        '\u529D'..'\u52A1',
        '\u52A8'..'\u52AB',
        '\u52B1'..'\u52B3',
        '\u52FE'..'\u52FF',
        '\u5305'..'\u5306',
        '\u5316'..'\u5317',
        '\u5339'..'\u533B',
        '\u5347'..'\u5348',
        '\u534E'..'\u534F',
        '\u5352'..'\u5353',
        '\u5355'..'\u5357',
        '\u5360'..'\u5362',
        '\u536F'..'\u5371',
        '\u5373'..'\u5374',
        '\u5384'..'\u5386',
        '\u538B'..'\u538D',
        '\u53C8'..'\u53CD',
        '\u53D6'..'\u53D9',
        '\u53E3'..'\u53E6',
        '\u53EA'..'\u53ED',
        '\u53EF'..'\u53F0',
        '\u53F2'..'\u53F3',
        '\u53F6'..'\u53F9',
        '\u5403'..'\u5404',
        '\u5408'..'\u540A',
        '\u540C'..'\u540E',
        '\u5410'..'\u5411',
        '\u5426'..'\u5427',
        '\u542B'..'\u542C',
        '\u5438'..'\u5439',
        '\u547C'..'\u547D',
        '\u54A6'..'\u54A8',
        '\u54C0'..'\u54C1',
        '\u54C7'..'\u54C9',
        '\u54CD'..'\u54CE',
        '\u54E5'..'\u54E6',
        '\u54E9'..'\u54EA',
        '\u552E'..'\u552F',
        '\u5565'..'\u5566',
        '\u559C'..'\u559D',
        '\u56FD'..'\u56FE',
        '\u5750'..'\u5751',
        '\u575A'..'\u575C',
        '\u5782'..'\u5783',
        '\u57F9'..'\u57FA',
        '\u58EB'..'\u58EC',
        '\u5915'..'\u5916',
        '\u5929'..'\u592B',
        '\u5937'..'\u593A',
        '\u5947'..'\u5949',
        '\u5956'..'\u5957',
        '\u5973'..'\u5974',
        '\u5987'..'\u5988',
        '\u59CA'..'\u59CB',
        '\u59D0'..'\u59D1',
        '\u59D3'..'\u59D4',
        '\u5A03'..'\u5A04',
        '\u5B54'..'\u5B55',
        '\u5B57'..'\u5B59',
        '\u5B5C'..'\u5B5D',
        '\u5B63'..'\u5B64',
        '\u5B87'..'\u5B89',
        '\u5B8B'..'\u5B8C',
        '\u5B97'..'\u5B9E',
        '\u5BA1'..'\u5BA4',
        '\u5BB3'..'\u5BB4',
        '\u5BBD'..'\u5BBF',
        '\u5BC4'..'\u5BC7',
        '\u5BDD'..'\u5BDF',
        '\u5BF8'..'\u5BF9',
        '\u5BFB'..'\u5BFC',
        '\u5C3C'..'\u5C3E',
        '\u5C40'..'\u5C42',
        '\u5C81'..'\u5C82',
        '\u5C97'..'\u5C98',
        '\u5C9A'..'\u5C9B',
        '\u5DDD'..'\u5DDE',
        '\u5DE5'..'\u5DE8',
        '\u5DF1'..'\u5DF4',
        '\u5E01'..'\u5E03',
        '\u5E15'..'\u5E16',
        '\u5E2D'..'\u5E2E',
        '\u5E72'..'\u5E74',
        '\u5E7B'..'\u5E7D',
        '\u5E93'..'\u5E95',
        '\u5E99'..'\u5E9A',
        '\u5E9E'..'\u5E9F',
        '\u5EA6'..'\u5EA7',
        '\u5EB7'..'\u5EB8',
        '\u5EF6'..'\u5EF7',
        '\u5F02'..'\u5F04',
        '\u5F17'..'\u5F18',
        '\u5F1F'..'\u5F20',
        '\u5F25'..'\u5F26',
        '\u5F39'..'\u5F3A',
        '\u5F52'..'\u5F53',
        '\u5F6C'..'\u5F6D',
        '\u5F70'..'\u5F71',
        '\u5F7B'..'\u5F7C',
        '\u5F80'..'\u5F81',
        '\u5F84'..'\u5F85',
        '\u5F8B'..'\u5F8C',
        '\u5FC5'..'\u5FC6',
        '\u5FCC'..'\u5FCD',
        '\u5FD7'..'\u5FD9',
        '\u6000'..'\u6001',
        '\u6015'..'\u6016',
        '\u6027'..'\u6028',
        '\u6068'..'\u6069',
        '\u606F'..'\u6070',
        '\u609F'..'\u60A0',
        '\u60E7'..'\u60E8',
        '\u6108'..'\u6109',
        '\u620F'..'\u6212',
        '\u623F'..'\u6241',
        '\u624D'..'\u624E',
        '\u626B'..'\u626F',
        '\u627E'..'\u6280',
        '\u6297'..'\u6298',
        '\u62A4'..'\u62A5',
        '\u62AB'..'\u62AC',
        '\u62C5'..'\u62C6',
        '\u62DB'..'\u62DC',
        '\u62E5'..'\u62E6',
        '\u62E8'..'\u62E9',
        '\u62FE'..'\u62FF',
        '\u6324'..'\u6325',
        '\u6361'..'\u6362',
        '\u6388'..'\u6389',
        '\u63A7'..'\u63AA',
        '\u63CF'..'\u63D0',
        '\u642C'..'\u642D',
        '\u64CD'..'\u64CE',
        '\u653E'..'\u653F',
        '\u6562'..'\u6563',
        '\u65AF'..'\u65B0',
        '\u65BC'..'\u65BD',
        '\u65E5'..'\u65E9',
        '\u660E'..'\u660F',
        '\u661F'..'\u6620',
        '\u6652'..'\u6653',
        '\u666E'..'\u666F',
        '\u6696'..'\u6697',
        '\u66FE'..'\u6700',
        '\u6708'..'\u6709',
        '\u672A'..'\u672D',
        '\u6742'..'\u6743',
        '\u6750'..'\u6751',
        '\u676F'..'\u6770',
        '\u677E'..'\u677F',
        '\u679C'..'\u679D',
        '\u67AA'..'\u67AB',
        '\u67CF'..'\u67D0',
        '\u67D3'..'\u67D4',
        '\u67F3'..'\u67F4',
        '\u6837'..'\u6839',
        '\u68AF'..'\u68B0',
        '\u6B20'..'\u6B23',
        '\u6B62'..'\u6B66',
        '\u6B8A'..'\u6B8B',
        '\u6BD4'..'\u6BD5',
        '\u6C5F'..'\u6C61',
        '\u6C88'..'\u6C89',
        '\u6CC9'..'\u6CCA',
        '\u6CE1'..'\u6CE3',
        '\u6D3D'..'\u6D3E',
        '\u6D4E'..'\u6D4F',
        '\u6D69'..'\u6D6A',
        '\u6D88'..'\u6D89',
        '\u706F'..'\u7070',
        '\u70B8'..'\u70B9',
        '\u70E6'..'\u70E7',
        '\u7235'..'\u7238',
        '\u7247'..'\u7248',
        '\u7261'..'\u7262',
        '\u7279'..'\u727A',
        '\u731B'..'\u731C',
        '\u73AF'..'\u73B0',
        '\u7433'..'\u7434',
        '\u745E'..'\u745F',
        '\u7530'..'\u7533',
        '\u7537'..'\u7538',
        '\u767D'..'\u767E',
        '\u7686'..'\u7687',
        '\u76D1'..'\u76D2',
        '\u771F'..'\u7720',
        '\u7801'..'\u7802',
        '\u788D'..'\u788E',
        '\u795D'..'\u795E',
        '\u79C0'..'\u79C1',
        '\u79D1'..'\u79D2',
        '\u79EF'..'\u79F0',
        '\u7A0D'..'\u7A0E',
        '\u7A76'..'\u7A77',
        '\u7A79'..'\u7A7A',
        '\u7ADE'..'\u7AE0',
        '\u7CD5'..'\u7CD6',
        '\u7EA6'..'\u7EA7',
        '\u7EB2'..'\u7EB3',
        '\u7EB7'..'\u7EB8',
        '\u7EC3'..'\u7EC4',
        '\u7EC6'..'\u7EC8',
        '\u7ED8'..'\u7ED9',
        '\u7EDC'..'\u7EDD',
        '\u7EE9'..'\u7EEA',
        '\u7EF4'..'\u7EF5',
        '\u7F50'..'\u7F51',
        '\u7FFB'..'\u7FFC',
        '\u8000'..'\u8001',
        '\u800C'..'\u800D',
        '\u80A4'..'\u80A5',
        '\u817E'..'\u817F',
        '\u81F3'..'\u81F4',
        '\u820C'..'\u820D',
        '\u821E'..'\u821F',
        '\u82AC'..'\u82AD',
        '\u82E5'..'\u82E6',
        '\u8302'..'\u8303',
        '\u83AA'..'\u83AB',
        '\u83B1'..'\u83B2',
        '\u8424'..'\u8425',
        '\u8427'..'\u8428',
        '\u867D'..'\u867E',
        '\u88C1'..'\u88C2',
        '\u89C1'..'\u89C2',
        '\u89C8'..'\u89C9',
        '\u8BA1'..'\u8BA2',
        '\u8BA8'..'\u8BA9',
        '\u8BAD'..'\u8BB0',
        '\u8BB7'..'\u8BB8',
        '\u8BBE'..'\u8BBF',
        '\u8BDD'..'\u8BDE',
        '\u8BE5'..'\u8BE6',
        '\u8BF7'..'\u8BF8',
        '\u8BFA'..'\u8BFB',
        '\u8C0A'..'\u8C0B',
        '\u8D1D'..'\u8D1F',
        '\u8D21'..'\u8D25',
        '\u8D27'..'\u8D2A',
        '\u8D34'..'\u8D35',
        '\u8D38'..'\u8D3A',
        '\u8D4B'..'\u8D4C',
        '\u8D4F'..'\u8D50',
        '\u8D5A'..'\u8D5B',
        '\u8D8A'..'\u8D8B',
        '\u8F68'..'\u8F69',
        '\u8F6E'..'\u8F70',
        '\u8F85'..'\u8F86',
        '\u8F88'..'\u8F89',
        '\u8FA8'..'\u8FA9',
        '\u8FB0'..'\u8FB1',
        '\u8FC7'..'\u8FC8',
        '\u8FD0'..'\u8FD1',
        '\u8FD8'..'\u8FD9',
        '\u8FDB'..'\u8FDF',
        '\u8FEA'..'\u8FEB',
        '\u9000'..'\u9003',
        '\u9009'..'\u900A',
        '\u900F'..'\u9010',
        '\u901A'..'\u901B',
        '\u901F'..'\u9020',
        '\u903B'..'\u903C',
        '\u906D'..'\u906E',
        '\u907F'..'\u9080',
        '\u9177'..'\u9178',
        '\u91CC'..'\u91CF',
        '\u9500'..'\u9501',
        '\u95ED'..'\u95EE',
        '\u9632'..'\u9636',
        '\u963F'..'\u9640',
        '\u9644'..'\u9646',
        '\u9669'..'\u966A',
        '\u9675'..'\u9677',
        '\u968F'..'\u9690',
        '\u96C4'..'\u96C6',
        '\u96F6'..'\u96F7',
        '\u9738'..'\u9739',
        '\u9875'..'\u9876',
        '\u9879'..'\u987B',
        '\u987D'..'\u987F',
        '\u9886'..'\u9887',
        '\u9897'..'\u9898',
        '\u98D8'..'\u98D9',
        '\u98DE'..'\u98DF',
        '\u996D'..'\u996E',
        '\u9970'..'\u9971',
        '\uFE30'..'\uFE31',
        '\uFE33'..'\uFE44',
        '\uFE49'..'\uFE52',
        '\uFE54'..'\uFE57',
        '\uFE59'..'\uFE61',
        '\uFE6A'..'\uFE6B',
        '\uFF01'..'\uFF03',
        '\uFF05'..'\uFF0A',
        '\uFF0C'..'\uFF0F',
        '\uFF1A'..'\uFF1B',
        '\uFF1F'..'\uFF20',
        '\uFF3B'..'\uFF3D',
    )

    val values = symbols + ranges.map { it.joinToString("") }.joinToString("")
}