package casperix.font.pixel

import casperix.font.FontMetrics
import casperix.font.FontReference
import casperix.graphic.pixel_map.PixelMapRegion
import casperix.math.vector.int32.Vector2i
import casperix.misc.mapping

data class PixelFont(val reference: FontReference, val metrics: FontMetrics, val symbols: Collection<PixelFontSymbol>) {
    val symbolMap = symbols.mapping { Pair(it.char, it) }
    val lineHeight = metrics.lineHeight * reference.leading.factor
}

data class PixelFontSymbol(val char: Char, val baselineOffset: Vector2i, val size: Vector2i, val graphic: PixelMapRegion?)