package casperix.graphic.pixel_map

import casperix.dimension
import casperix.math.axis_aligned.int32.Box2i
import casperix.math.vector.int32.Vector2i
import casperix.renderer.pixel_map.PixelMap

@ExperimentalUnsignedTypes
data class PixelMapRegion(val atlas: PixelMap, val region: Box2i) {
    val dimension get() = region.dimension

    constructor(pixelMap: PixelMap) : this(pixelMap, Box2i(Vector2i.ZERO, pixelMap.dimension().toVector2i()))
}