package  casperix.loader

import casperix.renderer.pixel_map.PixelMap
import casperix.signals.concrete.EitherFuture
import casperix.signals.concrete.EitherSignal


expect object ResourceLoader : AbstractResourceLoader

interface AbstractResourceLoader {
    fun load(path: String): EitherFuture<ByteArray, ResourceLoadError>
    fun loadText(path: String): EitherFuture<String, ResourceLoadError> {
        val proxy = EitherSignal<String, ResourceLoadError>()

        load(path).then({ bytes ->
            proxy.accept(bytes.decodeToString())
        }, {
            proxy.reject(it)
        })
        return proxy
    }

    fun loadImage(path: String): EitherFuture<PixelMap, ResourceLoadError>

    fun saveImage(path: String, pixelMap: PixelMap): ResourceSaveError?
}