package casperix.renderer.text

import casperix.font.FontReference
import casperix.font.pixel.PixelFont
import casperix.math.axis_aligned.float32.Dimension2f
import casperix.math.color.Color
import casperix.math.color.Colors
import casperix.math.quad_matrix.float32.Matrix3f
import casperix.math.vector.float32.Vector2f
import casperix.renderer.Renderer2D
import casperix.renderer.misc.AlignMode


expect object TextRenderer : TextRendererApi

@ExperimentalUnsignedTypes
interface TextRendererApi {
    fun getPixelFont(reference: FontReference): PixelFont

    fun Renderer2D.drawText(
        text: String,
        reference: FontReference,
        matrix: Matrix3f,
        availableArea: Vector2f = Vector2f(100f),
        color: Color = Colors.WHITE,
        backgroundColor: Color? = null
    ): TextLayout


    fun Renderer2D.drawText(
        text: String,
        reference: FontReference,
        position: Vector2f,
        availableArea: Vector2f = Vector2f(100f),
        color: Color = Colors.WHITE,
        backgroundColor: Color? = null
    ): TextLayout {
        return drawText(text, reference, Matrix3f.translate(position), availableArea, color, backgroundColor)
    }

    fun Renderer2D.drawTextLayout(matrix: Matrix3f, color: Color, layout: TextLayout)

    fun Renderer2D.drawTextLayoutMetrics(matrix: Matrix3f, font: FontReference, layout: TextLayout) {
        drawTextLayoutMetrics(matrix, getPixelFont(font), layout)
    }

    fun Renderer2D.drawTextLayoutMetrics(matrix: Matrix3f, font: PixelFont, layout: TextLayout)

    fun createTextLayout(text: String, areaSize: Vector2f,  font: PixelFont): TextLayout

    fun createTextLayout(text: String, areaSize: Vector2f, reference: FontReference): TextLayout {
        return createTextLayout(text, areaSize, getPixelFont(reference))
    }
}