package casperix.renderer.text.impl

object TextProcessor {
    private val BREAK_RULE = Regex("(\\r\\n|\\r|\\n| |。|，)")

    fun splitByGroups(text: String): List<String> {
        var nextIndex = 0
        val groups = BREAK_RULE.findAll(text).toList().flatMap {
            val value = it.value
            val range = it.range

            val divider = when (value) {
                "\r\n" -> "\n"
                "\r" -> "\n"
                "\n" -> "\n"
                " " -> " "
                else -> if (!range.isEmpty()) {
                    value
                } else {
                    null
                }
            }

            val beforeDivider = if (nextIndex < range.first) {
                text.substring(nextIndex until range.first)
            } else null

            nextIndex = it.range.last + 1
            listOfNotNull(beforeDivider, divider)
        }

        val afterDivider = if (nextIndex < text.length) {
            text.substring(nextIndex until text.length)
        } else null

        return groups + listOfNotNull(afterDivider)
    }
}