package ru.casperix.signals.api


interface CustomEitherFuture<AcceptListener, RejectListener, Slot> {
	val complete: Boolean

	val acceptFuture: CustomFuture<AcceptListener, Slot>
	val rejectFuture: CustomFuture<RejectListener, Slot>

	fun then(accept: AcceptListener, reject: RejectListener): Pair<Slot?, Slot?> {
		return Pair(
				acceptFuture.then(accept),
				rejectFuture.then(reject)
		)
	}

	fun thenAccept(accept: AcceptListener): Slot? {
		return acceptFuture.then(accept)
	}

	fun thenReject(reject: RejectListener): Slot? {
		return rejectFuture.then(reject)
	}
}

