package ru.casperix.simple_console.article

import ru.casperix.misc.compute
import ru.casperix.simple_console.article.*
import kotlin.math.max

object ArticleFormat {
    fun Article.asRaw(): String {
        return flatMap {
            when (it) {
                is TitleSection -> listOf("==== ${it.value} ====")
                is TextSection -> listOf(it.value)
                is NameValueSection -> listOf(it.name + ": " + it.value)
                is TableSection -> tableAsLines(it)
            }
        }.joinToString("\n")
    }

    private fun tableAsLines(section: TableSection): List<String> {
        val cellWidthByColumn = mutableMapOf<Int, Int>()

        (0 until section.map.sizeY).forEach { row ->
            (0 until section.map.sizeX).forEach { column ->
                val cell = section.map.get(column, row)
                cellWidthByColumn.compute(column) { _, last -> max(cell.length, last ?: 0) }
            }
        }
        return (0 until section.map.sizeY).map { row ->
            (0 until section.map.sizeX).map { column ->
                val cell = section.map.get(column, row)
                val width = cellWidthByColumn[column] ?: 0
                cell.padEnd(width, ' ')
            }.joinToString(" ")
        }
    }

    fun Article.asMD(): String {
        return flatMap {
            when (it) {
                is TitleSection -> listOf("#### " + it.value)
                is TextSection -> listOf(it.value)
                is NameValueSection -> listOf(it.name + ": " + it.value)
                is TableSection -> tableAsLines(it)//TODO: md have specific format for table
            }
        }.joinToString("\n\n")
    }
}