package ru.casperix.simple_console.core


private val INVALID_ANSWER = "Invalid command output"

fun interface ConsoleAction {
    fun complete(console: OutputAction, arguments: List<String>)
}

fun ConsoleLogic.registerContinuousPrint(info: ConsoleCommand, outputBuilder: (List<String>) -> String) {
    registerAction(info) { outputAction, arguments -> outputAction.set(runCatching { outputBuilder(arguments) }.getOrDefault(INVALID_ANSWER)) }
}

fun ConsoleLogic.registerOncePrint(info: ConsoleCommand, outputBuilder: (List<String>) -> String) {
    registerAction(info) { outputAction, arguments -> outputAction.set(runCatching { outputBuilder(arguments) }.getOrDefault(INVALID_ANSWER)); outputAction.stop() }
}