package ru.casperix.simple_console.ui

import ru.casperix.simple_console.core.*

class ConsoleBuilder(val console: ConsoleLogic) {

    fun registerSingle(info: ConsoleCommand, operation: CommandContext.() -> String) {
        console.registerOncePrint(info) { arguments ->
            operation(CommandContext(console, arguments))
        }
    }

    fun registerContinuous(info: ConsoleCommand, operation: CommandContext.() -> String) {
        console.registerContinuousPrint(info) { arguments ->
            operation(CommandContext(console, arguments))
        }
    }

    fun registerDefault() {
        registerSingle(ConsoleCommand("Print", "Print all arguments semicolon divided ")) {
            arguments.joinToString(";")
        }
        registerSingle(ConsoleCommand("HelpCommand", "Print detail command description", ConsoleCommandArgument("String", "command name"))) {
            readString {
                val score = console.autocompleteCommand(it).firstOrNull() ?: return@readString "Cant parse command"
                val commandName = score.candidate.name
                val handler = console.getAllActions().first { it.command.name == commandName }
                val command = handler.command

                command.name + "\n\n" + command.arguments.joinToString("\n") { argumentInfo -> argumentInfo.type + " - " + argumentInfo.description + (if (argumentInfo.optional) " (optional)" else "") } + "\n\n" + command.description
            }
        }

        registerSingle(ConsoleCommand("Help", "Print all commands")) {
            console.getAllActions().map { it.command.name + " - " + it.command.description }.sorted().joinToString("\n")
        }
    }
}