package ru.casperix.simple_console.ui

import ru.casperix.light_ui.component.panel.QuadBodySkin
import ru.casperix.light_ui.component.panel.QuadSkin
import ru.casperix.light_ui.component.text.LabelSkin
import ru.casperix.light_ui.component.text.TextEditorSkin
import ru.casperix.math.color.ColorCode
import ru.casperix.multiplatform.font.FontReference
import ru.casperix.multiplatform.font.FontWeight

class ConsoleSkin(
    val monospacedFont: FontReference = FontReference("Monospaced", 20, weight = FontWeight.BOLD),
    val consoleInputField: TextEditorSkin = TextEditorSkin( LabelSkin(monospacedFont, ColorCode(255u, 255u, 255u, 255u), null)),
    val consoleOutputLabel: LabelSkin = LabelSkin(monospacedFont, ColorCode(255u, 255u, 255u, 255u), null),
    val consoleHelperLabel: LabelSkin = LabelSkin(monospacedFont, ColorCode(180u, 180u, 180u, 255u), null),
    val consoleWidth: Float = 500f,
    val baseRowHeight: Float = 50f,
    val primaryBack:QuadSkin = QuadSkin(QuadBodySkin(ColorCode(60u, 60u, 60u, 180u), 1f), null),
    val inputBack:QuadSkin = QuadSkin(QuadBodySkin(ColorCode(60u, 60u, 60u, 220u), 1f), null),
)