package ru.casperix.simple_console.core

import ru.casperix.signals.concrete.Signal


class ConsoleLogic {
    class ActionEvent(val input: CommandInput, val action: ConsoleAction)


    class ActionHandler(val command: ConsoleCommand, val action: ConsoleAction)

    val actionStarted = Signal<ActionEvent>()
    val outputSignal = Signal<String>()

    private val history = mutableListOf<ActionEvent>()
    private val infoMap = mutableMapOf<String, ActionHandler>()
    private var current: ActionEvent? = null

    private val output = object : OutputAction {
        override fun set(value: String) {
            outputSignal.set(value)
        }

        override fun stop() {
            current = null
        }
    }

    fun getHistory(): List<ActionEvent> {
        return history
    }

    fun getCurrentAction(): ActionEvent? {
        return current
    }

    fun getAllNames(): Collection<String> {
        return infoMap.values.map { it.command.name }
    }

    fun getAllActions(): Collection<ActionHandler> {
        return infoMap.values
    }

//    fun registerAction(name: String, arguments: List<ArgumentInfo>, description: String, action: ConsoleAction) {
//        registerAction(ActionHandler(ActionInfo(name, arguments, description), action))
//    }

    fun registerAction(info: ConsoleCommand, action: ConsoleAction) {
        registerAction(ActionHandler(info, action))
    }

    fun registerAction(handler: ActionHandler) {
        infoMap[handler.command.name.lowercase()] = handler
    }

    fun launchAction(input: String) {
        val command = CommandParser.parseInput(input)
        if (command != null) {
            val key = command.name.lowercase()
            val entry = infoMap[key]
            if (entry != null) {
                dispatch(ActionEvent(CommandInput(entry.command.name, command.arguments), entry.action))
                return
            }
        }

        current = null
        output.set("Can't parse & execute: $command")
    }

    private fun dispatch(event: ActionEvent) {
        current = event
        history += event
        update()
        actionStarted.set(event)
    }

    fun autocompleteCommand(raw: String): List<CommandParser.CommandScore> {
        return CommandParser.autocompleteCommand(getAllNames(), raw)
    }

    fun update() {
        val value = current ?: return
        value.action.complete(output, value.input.arguments)
    }
}