package ru.casperix.simple_console.ui

import ru.casperix.simple_console.core.ConsoleLogic

open class CommandContext(val console: ConsoleLogic, val arguments: List<String>) {
    var indexPosition = 0

    fun readString(onString: (String) -> String): String {
        val index = indexPosition++
        val raw = arguments.getOrNull(index) ?: return "Undefined argument by index: $index"
        return onString(raw)
    }

    fun readLong(default: Long? = null, onLong: (Long) -> String): String {
        val index = indexPosition++
        val raw = arguments.getOrNull(index) ?: return "Undefined argument by index: $index"
        val value = runCatching {
            raw.toLong()
        }.getOrNull() ?: run {
            return if (default != null) {
                onLong(default)
            } else {
                "Not number by index $index"
            }
        }


        return onLong(value)
    }

    fun readInt(default: Int? = null, onInt: (Int) -> String): String {
        val index = indexPosition++
        val raw = arguments.getOrNull(index) ?: return "Undefined argument by index: $index"
        val value = runCatching {
            raw.toInt()
        }.getOrNull() ?: run {
            return if (default != null) {
                onInt(default)
            } else {
                "Not number by index $index"
            }
        }

        return onInt(value)
    }


}