package ru.casperix.simple_console.ui

import ru.casperix.light_ui.component.panel.Panel
import ru.casperix.light_ui.component.scroll.ScrollBox
import ru.casperix.light_ui.component.text.Label
import ru.casperix.light_ui.component.text.editor.TextEditor
import ru.casperix.light_ui.element.ContentDimension
import ru.casperix.light_ui.element.FixedDimension
import ru.casperix.light_ui.element.SizeMode
import ru.casperix.light_ui.element.setSizeMode
import ru.casperix.light_ui.layout.Layout
import ru.casperix.light_ui.skin.SkinProvider
import ru.casperix.renderer.misc.AlignMode

class ConsoleView(val consoleSkin: ConsoleSkin = ConsoleSkin()) {
    val commandInfo = Label(skin = consoleSkin.consoleHelperLabel)
    val outputText = Label(alignMode = AlignMode.LEFT_TOP, skin = consoleSkin.consoleOutputLabel).setSizeMode(FixedDimension(consoleSkin.consoleWidth), ContentDimension)
    val inputField = TextEditor().apply {
        skin = consoleSkin.consoleInputField
    }
    val helperArea = Label(skin = consoleSkin.consoleHelperLabel)

    val root = Panel(
        Layout.VERTICAL,
        commandInfo.setSizeMode(SizeMode.row),
        ScrollBox(SkinProvider.skin.scrollBox.copy(back = null)).setSizeMode(SizeMode.view).apply {
            content.element = outputText
        },
        Panel(
            Layout.VERTICAL,
            helperArea.setSizeMode(SizeMode.row),
            inputField.setSizeMode(SizeMode.fixedHeight(consoleSkin.baseRowHeight)),
        ).setSizeMode(SizeMode.row).apply {
            skin = consoleSkin.inputBack
        },
    ).setSizeMode(SizeMode.max).apply {
        skin = consoleSkin.primaryBack
    }
}