package io.gitlab.embedSoft.lvglKt.drivers.input

import io.gitlab.embedSoft.lvglKt.core.Image
import io.gitlab.embedSoft.lvglKt.core.Screen
import lvDrivers.evdev_init
import lvgl.lv_indev_type_t

public actual fun setupMouse(cursorImg: String): Pair<InputDeviceDriver, InputDevice> {
    val inDevDriver = InputDeviceDriver.create()
    inDevDriver.type = lv_indev_type_t.LV_INDEV_TYPE_POINTER
    // Register the input device so it can be used.
    val mouseInDev = inDevDriver.register()
    // Create an image for the cursor.
    val cursor = Image.create(Screen.activeScreen)
    cursor.setSrc(cursorImg)
    // Connect the image to the input device.
    mouseInDev.setCursor(cursor)
    return inDevDriver to mouseInDev
}

public actual fun setupTouchScreen(): Pair<InputDeviceDriver, InputDevice> {
    val inDevDriver = InputDeviceDriver.create()
    inDevDriver.type = lv_indev_type_t.LV_INDEV_TYPE_POINTER
    // Register the input device so it can be used.
    val touchScreenInDev = inDevDriver.register()
    return inDevDriver to touchScreenInDev
}

public actual fun initEvdev() {
    evdev_init()
}
