package io.gitlab.embedSoft.lvglKt.drivers

import io.gitlab.embedSoft.lvglKt.core.lvglObject.LvglObjectBase
import io.gitlab.embedSoft.lvglKt.core.styling.*
import kotlinx.cinterop.*
import lvgl.*

public actual class Theme private constructor(ptr: CPointer<lv_theme_t>?){
    public val lvThemePtr: CPointer<lv_theme_t>? = ptr

    public actual companion object {
        public fun fromPointer(ptr: CPointer<lv_theme_t>?): Theme = Theme(ptr)

        public actual fun create(
            display: Display,
            primaryColor: Color,
            secondaryColor: Color,
            dark: Boolean,
            vararg fonts: Font
        ): Theme = memScoped {
            val tmpArray = allocArray<lv_font_t>(fonts.size)
            fonts.forEachIndexed { pos, item -> item.lvFontPtr?.pointed?.copy(tmpArray[pos]) }
            val ptr = lv_theme_default_init(
                disp = display.lvDispPtr,
                color_primary = primaryColor.toCValue(),
                color_secondary = secondaryColor.toCValue(),
                dark = dark,
                font = tmpArray
            )
            return fromPointer(ptr)
        }

        public actual fun getPrimaryColor(obj: LvglObjectBase): Color =
            lv_theme_get_color_primary(obj.lvObjPtr).toColor()

        public actual fun getSecondaryColor(obj: LvglObjectBase): Color =
            lv_theme_get_color_secondary(obj.lvObjPtr).toColor()

        public actual fun getSmallFont(obj: LvglObjectBase): Font = lv_theme_get_font_small(obj.lvObjPtr).toFont()

        public actual fun getNormalFont(obj: LvglObjectBase): Font = lv_theme_get_font_normal(obj.lvObjPtr).toFont()

        public actual fun getLargeFont(obj: LvglObjectBase): Font = lv_theme_get_font_large(obj.lvObjPtr).toFont()
    }

    public actual fun setParent(parent: Theme) {
        lv_theme_set_parent(lvThemePtr, parent.lvThemePtr)
    }

    public actual fun setApplyCallback(callback: ThemeCallback) {
        lvThemePtr?.pointed?.user_data = callback.stableRef.asCPointer()
        lv_theme_set_apply_cb(lvThemePtr, callback.lvThemeApplyCbPtr)
    }
}

public fun CPointer<lv_theme_t>?.toTheme(): Theme = Theme.fromPointer(this)
