/*
 * Copyright (C) 2024 Berner Fachhochschule https://e-voting.bfh.ch
 *
 *  - This program is free software: you can redistribute it and/or modify                           -
 *  - it under the terms of the GNU Affero General Public License as published by                    -
 *  - the Free Software Foundation, either version 3 of the License, or                              -
 *  - (at your option) any later version.                                                            -
 *  -                                                                                                -
 *  - This program is distributed in the hope that it will be useful,                                -
 *  - but WITHOUT ANY WARRANTY; without even the implied warranty of                                 -
 *  - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the                                   -
 *  - GNU General Public License for more details.                                                   -
 *  -                                                                                                -
 *  - You should have received a copy of the GNU Affero General Public License                       -
 *  - along with this program. If not, see <http://www.gnu.org/licenses/>.                           -
 */
package ch.openchvote.algorithms.parameters.usability;

/**
 * This is a marker interface for classes or interfaces representing an algorithm's usability parameters.
 */
public interface UsabilityParameters {

    /**
     * Returns the identifier of the usability configuration provided by the parameters.
     *
     * @return The identifier of the usability configuration
     */
    String getUsabilityConfiguration();

    /**
     * Returns the identifier of the security level provided by the parameters.
     *
     * @return The identifier of the security level
     */
    String getSecurityLevel();

}
