/*
 * Copyright (C) 2024 Berner Fachhochschule https://e-voting.bfh.ch
 *
 *  - This program is free software: you can redistribute it and/or modify                           -
 *  - it under the terms of the GNU Affero General Public License as published by                    -
 *  - the Free Software Foundation, either version 3 of the License, or                              -
 *  - (at your option) any later version.                                                            -
 *  -                                                                                                -
 *  - This program is distributed in the hope that it will be useful,                                -
 *  - but WITHOUT ANY WARRANTY; without even the implied warranty of                                 -
 *  - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the                                   -
 *  - GNU General Public License for more details.                                                   -
 *  -                                                                                                -
 *  - You should have received a copy of the GNU Affero General Public License                       -
 *  - along with this program. If not, see <http://www.gnu.org/licenses/>.                           -
 */
package ch.openchvote.algorithms.protocols.common.model;

import java.math.BigInteger;

/**
 * Model class for queries inheriting from {@link Encryption}, with specific constructor and getter methods.
 */
@SuppressWarnings("MissingJavadoc")
public final class Query extends Encryption {

    public Query(BigInteger a_1, BigInteger a_2) {
        super(a_1, a_2);
    }

    public BigInteger get_a_1() {
        return this.getFirst();
    }

    public BigInteger get_a_2() {
        return this.getSecond();
    }

}
