/*
 * Copyright (C) 2024 Berner Fachhochschule https://e-voting.bfh.ch
 *
 *  - This program is free software: you can redistribute it and/or modify                           -
 *  - it under the terms of the GNU Affero General Public License as published by                    -
 *  - the Free Software Foundation, either version 3 of the License, or                              -
 *  - (at your option) any later version.                                                            -
 *  -                                                                                                -
 *  - This program is distributed in the hope that it will be useful,                                -
 *  - but WITHOUT ANY WARRANTY; without even the implied warranty of                                 -
 *  - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the                                   -
 *  - GNU General Public License for more details.                                                   -
 *  -                                                                                                -
 *  - You should have received a copy of the GNU Affero General Public License                       -
 *  - along with this program. If not, see <http://www.gnu.org/licenses/>.                           -
 */
package ch.openchvote.algorithms.protocols.plain.model;

import ch.openchvote.utilities.sequence.Vector;
import ch.openchvote.utilities.tuples.Quadruple;

import java.math.BigInteger;

/**
 * Model class for the election authority's public data inheriting from {@link Quadruple}, with specific constructor and
 * getter methods.
 */
@SuppressWarnings("MissingJavadoc")
public final class PublicDataAdministrator extends Quadruple<BigInteger, KeyPairProof, Vector<BigInteger>, DecryptionProof> {

    public PublicDataAdministrator(BigInteger pk, KeyPairProof pi, Vector<BigInteger> bold_c, DecryptionProof pi_prime) {
        super(pk, pi, bold_c, pi_prime);
    }

    public BigInteger get_pk() {
        return this.getFirst();
    }

    public KeyPairProof get_pi() {
        return this.getSecond();
    }

    public Vector<BigInteger> get_bold_c() {
        return this.getThird();
    }

    public DecryptionProof get_pi_prime() {
        return this.getFourth();
    }

}
