/*
 * Copyright (C) 2024 Berner Fachhochschule https://e-voting.bfh.ch
 *
 *  - This program is free software: you can redistribute it and/or modify                           -
 *  - it under the terms of the GNU Affero General Public License as published by                    -
 *  - the Free Software Foundation, either version 3 of the License, or                              -
 *  - (at your option) any later version.                                                            -
 *  -                                                                                                -
 *  - This program is distributed in the hope that it will be useful,                                -
 *  - but WITHOUT ANY WARRANTY; without even the implied warranty of                                 -
 *  - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the                                   -
 *  - GNU General Public License for more details.                                                   -
 *  -                                                                                                -
 *  - You should have received a copy of the GNU Affero General Public License                       -
 *  - along with this program. If not, see <http://www.gnu.org/licenses/>.                           -
 */
package ch.openchvote.algorithms.protocols.writein.model;

import ch.openchvote.algorithms.protocols.common.model.ElectionParameters;
import ch.openchvote.utilities.sequence.IntMatrix;
import ch.openchvote.utilities.sequence.IntVector;
import ch.openchvote.utilities.tuples.Octuple;

/**
 * Model class for election parameters inheriting from {@link Octuple}, with specific constructor and getter
 * methods.
 */
@SuppressWarnings("MissingJavadoc")
public final class ElectionParametersWriteIn extends Octuple<String, IntVector, IntVector, IntVector, IntVector, IntMatrix, IntVector, IntVector> implements ElectionParameters {

    public ElectionParametersWriteIn(String U, IntVector bold_n, IntVector bold_k, IntVector bold_u, IntVector bold_w, IntMatrix bold_E, IntVector bold_v, IntVector bold_z) {
        super(U, bold_n, bold_k, bold_u, bold_w, bold_E, bold_v, bold_z);
    }

    public String get_U() {
        return this.getFirst();
    }

    public IntVector get_bold_n() {
        return this.getSecond();
    }

    public IntVector get_bold_k() {
        return this.getThird();
    }

    public IntVector get_bold_u() {
        return this.getFourth();
    }

    public IntVector get_bold_w() {
        return this.getFifth();
    }

    public IntMatrix get_bold_E() {
        return this.getSixth();
    }

    public IntVector get_bold_v() {
        return this.getSeventh();
    }

    public IntVector get_bold_z() {
        return this.getEighth();
    }

    @Override
    public int get_t() {
        return this.get_bold_n().getLength();
    }

    @Override
    public int get_u() {
        return this.get_bold_E().getWidth();
    }

    @Override
    public int get_n() {
        return this.get_bold_n().sum();
    }

    @Override
    public int get_N_E() {
        return this.get_bold_w().getLength();
    }

    @Override
    public int get_w() {
        return this.get_bold_w().max().orElse(0);
    }

    @SuppressWarnings("BooleanMethodIsAlwaysInverted")
    public boolean checkConsistency(String eventId) {
        return this.get_U().equals(eventId);
    }

}
