/*
 * Copyright (C) 2024 Berner Fachhochschule https://e-voting.bfh.ch
 *
 *  - This program is free software: you can redistribute it and/or modify                           -
 *  - it under the terms of the GNU Affero General Public License as published by                    -
 *  - the Free Software Foundation, either version 3 of the License, or                              -
 *  - (at your option) any later version.                                                            -
 *  -                                                                                                -
 *  - This program is distributed in the hope that it will be useful,                                -
 *  - but WITHOUT ANY WARRANTY; without even the implied warranty of                                 -
 *  - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the                                   -
 *  - GNU General Public License for more details.                                                   -
 *  -                                                                                                -
 *  - You should have received a copy of the GNU Affero General Public License                       -
 *  - along with this program. If not, see <http://www.gnu.org/licenses/>.                           -
 */
package ch.openchvote.algorithms.protocols.writein.model;

import ch.openchvote.utilities.sequence.Vector;
import ch.openchvote.utilities.tuples.Pair;
import ch.openchvote.utilities.tuples.Quadruple;
import ch.openchvote.utilities.tuples.Sextuple;

import java.math.BigInteger;

/**
 * Model class for shuffle proofs inheriting from {@link Quadruple}, with specific constructor and getter methods.
 */
@SuppressWarnings("MissingJavadoc")
public final class ShuffleProof extends Quadruple<BigInteger, Sextuple<BigInteger, BigInteger, BigInteger, Pair<BigInteger, BigInteger>, Vector<BigInteger>, Vector<BigInteger>>, Vector<BigInteger>, Vector<BigInteger>> {

    public ShuffleProof(BigInteger c, Sextuple<BigInteger, BigInteger, BigInteger, Pair<BigInteger, BigInteger>, Vector<BigInteger>, Vector<BigInteger>> s, Vector<BigInteger> bold_c, Vector<BigInteger> bold_c_hat) {
        super(c, s, bold_c, bold_c_hat);
    }

    public BigInteger get_c() {
        return this.getFirst();
    }

    public Sextuple<BigInteger, BigInteger, BigInteger, Pair<BigInteger, BigInteger>, Vector<BigInteger>, Vector<BigInteger>> get_s() {
        return this.getSecond();
    }

    public Vector<BigInteger> get_bold_c() {
        return this.getThird();
    }

    public Vector<BigInteger> get_bold_c_hat() {
        return this.getFourth();
    }

}
