/*
 * Copyright (C) 2024 Berner Fachhochschule https://e-voting.bfh.ch
 *
 *  - This program is free software: you can redistribute it and/or modify                           -
 *  - it under the terms of the GNU Affero General Public License as published by                    -
 *  - the Free Software Foundation, either version 3 of the License, or                              -
 *  - (at your option) any later version.                                                            -
 *  -                                                                                                -
 *  - This program is distributed in the hope that it will be useful,                                -
 *  - but WITHOUT ANY WARRANTY; without even the implied warranty of                                 -
 *  - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the                                   -
 *  - GNU General Public License for more details.                                                   -
 *  -                                                                                                -
 *  - You should have received a copy of the GNU Affero General Public License                       -
 *  - along with this program. If not, see <http://www.gnu.org/licenses/>.                           -
 */

import ch.openchvote.algorithms.JavaAlgorithmService;

/**
 * This module is an implementation of all CHVote algorithms.
 */
module ch.openchvote.algorithms {

    requires transitive ch.openchvote.utilities;

    exports ch.openchvote.algorithms;
    exports ch.openchvote.algorithms.parameters.security;
    exports ch.openchvote.algorithms.parameters.usability;
    exports ch.openchvote.algorithms.protocols.common.algorithms;
    exports ch.openchvote.algorithms.protocols.common.model;
    exports ch.openchvote.algorithms.general.algorithms;
    exports ch.openchvote.algorithms.general.model;
    exports ch.openchvote.algorithms.protocols.plain.algorithms;
    exports ch.openchvote.algorithms.protocols.plain.model;
    exports ch.openchvote.algorithms.protocols.writein.algorithms;
    exports ch.openchvote.algorithms.protocols.writein.model;

    uses ch.openchvote.algorithms.AlgorithmService;
    provides ch.openchvote.algorithms.AlgorithmService with JavaAlgorithmService;

}
