package com.simpay.processor.client;

import com.simpay.common.client.rest.AbstractRestClient;
import com.simpay.processor.client.model.operation.*;
import com.simpay.processor.client.model.response.*;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;

public class PaymentProcessorClient extends AbstractRestClient {

  public static final String STRING_FORMAT_2_ARGS = "%s/%s";
  public static final String PAYMENT_PROCESSOR_PATH = "payment-processor";

  public PaymentProcessorClient(final RestTemplate restTemplate, final String baseUrl) {
    super(restTemplate, baseUrl);
  }

  // Process Camtel bill payment
  public CamtelBillPaymentResponse payCamtelBill(CamtelBillPaymentRequest request) {
    String url =
        String.format(
            STRING_FORMAT_2_ARGS, getBaseUrl(), PAYMENT_PROCESSOR_PATH + "/pay-camtel-bill");
    HttpHeaders headers = new HttpHeaders();
    headers.setContentType(MediaType.APPLICATION_JSON);

    HttpEntity<CamtelBillPaymentRequest> requestEntity = new HttpEntity<>(request, headers);
    return getRestTemplate()
        .postForEntity(url, requestEntity, CamtelBillPaymentResponse.class)
        .getBody();
  }

  // Process START TIMES bill payment
  public StartTimesBillPaymentResponse payStartTimesBill(StartTimesBillPaymentRequest request) {
    String url =
        String.format(
            STRING_FORMAT_2_ARGS, getBaseUrl(), PAYMENT_PROCESSOR_PATH + "/pay-start-times-bill");
    HttpHeaders headers = new HttpHeaders();
    headers.setContentType(MediaType.APPLICATION_JSON);

    HttpEntity<StartTimesBillPaymentRequest> requestEntity = new HttpEntity<>(request, headers);
    return getRestTemplate()
        .postForEntity(url, requestEntity, StartTimesBillPaymentResponse.class)
        .getBody();
  }

  // Process DSTV bill payment
  public DsTvBillPaymentResponse payDsTvBill(DsTvBillPaymentRequest request) {
    String url =
        String.format(
            STRING_FORMAT_2_ARGS, getBaseUrl(), PAYMENT_PROCESSOR_PATH + "/pay-dstv-bill");
    HttpHeaders headers = new HttpHeaders();
    headers.setContentType(MediaType.APPLICATION_JSON);

    HttpEntity<DsTvBillPaymentRequest> requestEntity = new HttpEntity<>(request, headers);
    return getRestTemplate()
        .postForEntity(url, requestEntity, DsTvBillPaymentResponse.class)
        .getBody();
  }

  // Process Canal+ bill payment
  public CanalPlusBillPaymentResponse payCanalPlusBill(CanalPlusBillPaymentRequest request) {
    String url =
        String.format(
            STRING_FORMAT_2_ARGS, getBaseUrl(), PAYMENT_PROCESSOR_PATH + "/pay-canal-plus-bill");
    HttpHeaders headers = new HttpHeaders();
    headers.setContentType(MediaType.APPLICATION_JSON);

    HttpEntity<CanalPlusBillPaymentRequest> requestEntity = new HttpEntity<>(request, headers);
    return getRestTemplate()
        .postForEntity(url, requestEntity, CanalPlusBillPaymentResponse.class)
        .getBody();
  }

  // Process Eneo Postpaid bill payment
  public EneoBillPaymentResponse payEneoPostpaidBill(EneoBillPaymentRequest request) {
    String url =
        String.format(
            STRING_FORMAT_2_ARGS, getBaseUrl(), PAYMENT_PROCESSOR_PATH + "/pay-eneo-postpaid-bill");
    HttpHeaders headers = new HttpHeaders();
    headers.setContentType(MediaType.APPLICATION_JSON);

    HttpEntity<EneoBillPaymentRequest> requestEntity = new HttpEntity<>(request, headers);
    return getRestTemplate()
        .postForEntity(url, requestEntity, EneoBillPaymentResponse.class)
        .getBody();
  }
}
