package com.simpay.processor.client.enums;

import java.math.BigDecimal;

import com.simpay.payment.client.enums.PaymentType;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum CamtelBundleType {
  BLUE_MO_100XAF_1G_3H(
      "Blue Mo S 100 XAF - 1G pour 3 heures",
      BigDecimal.valueOf(100),
      PaymentType.SIMPAY_TO_CAMTEL_BLUE_MO_100XAF_1G_3H),
  BLUE_NIGHT_250XAF_5G_22H_6H(
      "Blue night 250 XAF - 5G de 22h à 6h",
      BigDecimal.valueOf(250),
      PaymentType.SIMPAY_TO_CAMTEL_BLUE_NIGHT_250XAF_5G_22H_6H),
  BLUE_MO_M_300XAF_1_5G_1J(
      "Blue Mo M 300 XAF - 1.5G pour 1 jour",
      BigDecimal.valueOf(300),
      PaymentType.SIMPAY_TO_CAMTEL_BLUE_MO_M_300XAF_1_5G_1J),
  BLUE_MO_L_500XAF_1_5G_2J(
      "Blue Mo L 500 XAF - 1.5G pour 2 jours",
      BigDecimal.valueOf(500),
      PaymentType.SIMPAY_TO_CAMTEL_BLUE_MO_L_500XAF_1_5G_2J),
  BLUE_GO_S_2000XAF_300M_1M(
      "Blue Go S 2000 XAF - 300M par jour pour 1 mois",
      BigDecimal.valueOf(2000),
      PaymentType.SIMPAY_TO_CAMTEL_BLUE_GO_S_2000XAF_300M_1M),
  BLUE_ONE_M_30DAYS(
      "Blue One M 30 days Appel+SMS+Internet illimité",
      BigDecimal.valueOf(3000),
      PaymentType.SIMPAY_TO_CAMTEL_BLUE_ONE_M_30DAYS),
  BLUE_MO_XXL_5000XAF_10G_30J(
      "Blue Mo XXL 5000 XAF - 10G pour 30 jours",
      BigDecimal.valueOf(5000),
      PaymentType.SIMPAY_TO_CAMTEL_BLUE_MO_XXL_5000XAF_10G_30J),
  BLUE_GO_L_10000XAF_2G_1M(
      "Blue Go L 10000 XAF - 2G par jour pour 1 mois",
      BigDecimal.valueOf(10000),
      PaymentType.SIMPAY_TO_CAMTEL_BLUE_GO_L_10000XAF_2G_1M),
  BLUE_GO_PLUS_S_15000XAF_60G_30J(
      "Blue Go Plus S 15000 XAF - 60G pour 30 jours",
      BigDecimal.valueOf(15000),
      PaymentType.SIMPAY_TO_CAMTEL_BLUE_GO_PLUS_S_15000XAF_60G_30J),
  BLUE_GO_XL_20000XAF_4_5G_1M(
      "Blue Go XL 20000 XAF - 4.5G par jour pour 1 Mois",
      BigDecimal.valueOf(20000),
      PaymentType.SIMPAY_TO_CAMTEL_BLUE_GO_XL_20000XAF_4_5G_1M),
  BLUE_GO_PLUS_M_25000XAF_135G_30J(
      "Blue Go Plus M 25000 XAF - 135G pour 30 jours",
      BigDecimal.valueOf(25000),
      PaymentType.SIMPAY_TO_CAMTEL_BLUE_GO_PLUS_M_25000XAF_135G_30J),
  BLUE_GO_XXL_35000XAF_8G_1M(
      "Blue Go XXL 35000 XAF - 8G par jour pour 1 mois",
      BigDecimal.valueOf(35000),
      PaymentType.SIMPAY_TO_CAMTEL_BLUE_GO_XXL_35000XAF_8G_1M),
  BLUE_GO_PLUS_L_40000XAF_240G_30J(
      "Blue Go Plus L 40000 XAF - 240G pour 30 jours",
      BigDecimal.valueOf(40000),
      PaymentType.SIMPAY_TO_CAMTEL_BLUE_GO_PLUS_L_40000XAF_240G_30J);

  private final String bundleName;
  private final BigDecimal bundleAmount;
  private final PaymentType paymentType;
}
