package com.simpay.processor.client.enums;

import java.math.BigDecimal;

import com.simpay.payment.client.enums.PaymentType;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum CanalPlusBundleType {
  CANAL_ACCESS_1_MONTH_5000XAF(
      "ACCESS-1-MOIS",
      BigDecimal.valueOf(5000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[1]/div",
      PaymentType.SIMPAY_TO_CANAL_PLUS_ACCESS_1_MONTH_5000XAF),
  CANAL_ACCESS_6_MONTH_30000XAF(
      "ACCESS-6-MOIS",
      BigDecimal.valueOf(30000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[2]/div",
      PaymentType.SIMPAY_TO_CANAL_PLUS_ACCESS_6_MONTH_30000XAF),
  CANAL_EVASION_1_MONTH_10000XAF(
      "EVASION-1-MOIS",
      BigDecimal.valueOf(10000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[3]/div",
      PaymentType.SIMPAY_TO_CANAL_PLUS_EVASION_1_MONTH_10000XAF),
  CANAL_EVASION_3_MONTH_30000XAF(
      "EVASION-3-MOIS",
      BigDecimal.valueOf(30000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[4]/div",
      PaymentType.SIMPAY_TO_CANAL_PLUS_EVASION_3_MONTH_30000XAF),
  CANAL_EVASION_6_MONTH_60000XAF(
      "EVASION-6-MOIS",
      BigDecimal.valueOf(60000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[5]/div",
      PaymentType.SIMPAY_TO_CANAL_PLUS_EVASION_6_MONTH_60000XAF),
  CANAL_EVASION_PLUS_1_MONTH_22500XAF(
      "EVASION + 1-MOIS",
      BigDecimal.valueOf(22500),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[6]/div",
      PaymentType.SIMPAY_TO_CANAL_PLUS_EVASION_PLUS_1_MONTH_22500XAF),
  CANAL_EVASION_PLUS_3_MONTH_67500XAF(
      "EVASION+ 3-MOIS",
      BigDecimal.valueOf(67500),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[7]/div",
      PaymentType.SIMPAY_TO_CANAL_PLUS_EVASION_PLUS_3_MONTH_67500XAF),
  CANAL_EVASION_PLUS_6_MONTH_135000XAF(
      "EVASION+ 6-MOIS",
      BigDecimal.valueOf(135000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[8]/div",
      PaymentType.SIMPAY_TO_CANAL_PLUS_EVASION_PLUS_6_MONTH_135000XAF),
  CANAL_TOUT_CANAL_PLUS_1_MONTH_45000XAF(
      "TOUT CANAL+ 1-MOIS",
      BigDecimal.valueOf(45000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[9]/div",
      PaymentType.SIMPAY_TO_CANAL_PLUS_TOUT_CANAL_PLUS_1_MONTH_45000XAF),
  CANAL_TOUT_CANAL_PLUS_3_MONTH_135000XAF(
      "TOUT CANAL+ 3-MOIS",
      BigDecimal.valueOf(135000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[10]/div",
      PaymentType.SIMPAY_TO_CANAL_PLUS_TOUT_CANAL_PLUS_3_MONTH_135000XAF),
  CANAL_TOUT_CANAL_PLUS_6_MONTH_270000XAF(
      "TOUT CANAL+ 6-MOIS",
      BigDecimal.valueOf(270000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[11]/div/button/div",
      PaymentType.SIMPAY_TO_CANAL_PLUS_TOUT_CANAL_PLUS_6_MONTH_270000XAF),
  CANAL_ACCESS_PLUS_1_MONTH_15000XAF(
      "ACCESS + 1-MOIS",
      BigDecimal.valueOf(15000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[12]/div",
      PaymentType.SIMPAY_TO_CANAL_PLUS_ACCESS_PLUS_1_MONTH_15000XAF),
  CANAL_UNA_WELCOME_DSTV_BASIC_1_MONTH_6000XAF(
      "UNA WELCOME + DSTV BASIC CASH 1 MONTH",
      BigDecimal.valueOf(6000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[13]/div",
      PaymentType.SIMPAY_TO_CANAL_PLUS_UNA_WELCOME_DSTV_BASIC_1_MONTH_6000XAF),
  CANAL_UNA_WELCOME_DSTV_PLUS_1_MONTH_13000XAF(
      "UNA WELCOME + DSTV PLUS CASH 1 MONTH",
      BigDecimal.valueOf(13000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[14]/div/button",
      PaymentType.SIMPAY_TO_CANAL_PLUS_UNA_WELCOME_DSTV_PLUS_1_MONTH_13000XAF),
  CANAL_ACCESS_PLUS_CHARME_12000XAF(
      "ACCESS + CHARME",
      BigDecimal.valueOf(12000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[15]/div",
      PaymentType.SIMPAY_TO_CANAL_PLUS_ACCESS_PLUS_CHARME_12000XAF),
  CANAL_ACCESS_ENG_BASIC_8000XAF(
      "ACCESS-ENG BASIC - 8000",
      BigDecimal.valueOf(8000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[16]/div",
      PaymentType.SIMPAY_TO_CANAL_PLUS_ACCESS_ENG_BASIC_8000XAF),
  CANAL_ENG_PLUS_ACCESS_15000XAF(
      "ENG PLUS - ACCESS - 15000",
      BigDecimal.valueOf(15000),
      "div.MuiBox-root:nth-child(17) > div:nth-child(1)",
      PaymentType.SIMPAY_TO_CANAL_PLUS_ENG_PLUS_ACCESS_15000XAF);

  private final String bundleName;
  private final BigDecimal bundleAmount;
  private final String xPath;
  private final PaymentType paymentType;
}
