package com.simpay.processor.client.enums;

import java.math.BigDecimal;

import com.simpay.payment.client.enums.PaymentType;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum DsTvBundleType {
  DSTV_PADI_1_MONTH_3500XAF(
      "DSTV PADI 1 MOIS - 3500 XAF",
      BigDecimal.valueOf(3500),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[1]/div",
      PaymentType.SIMPAY_TO_DSTV_PADI_1_MONTH_3500XAF),
  DSTV_YANGA_1_MONTH_6500XAF(
      "DSTV YANGA 1 MOIS - 6500 XAF",
      BigDecimal.valueOf(6500),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[2]/div",
      PaymentType.SIMPAY_TO_DSTV_YANGA_1_MONTH_6500XAF),
  DSTV_CONFAM_1_MONTH_9500XAF(
      "DSTV CONFAM 01 MOIS - 9500 XAF",
      BigDecimal.valueOf(9500),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[3]/div",
      PaymentType.SIMPAY_TO_DSTV_CONFAM_1_MONTH_9500XAF),
  DSTV_COMPACT_1_MONTH_13000XAF(
      "DSTV COMPACT 01 MOIS - 13000 XAF",
      BigDecimal.valueOf(13000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[4]/div",
      PaymentType.SIMPAY_TO_DSTV_COMPACT_1_MONTH_13000XAF),
  DSTV_COMPACT_PLUS_1_MONTH_19500XAF(
      "DSTV COMPACT PLUS 01 MOIS - 19500 XAF",
      BigDecimal.valueOf(19500),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[5]/div",
      PaymentType.SIMPAY_TO_DSTV_COMPACT_PLUS_1_MONTH_19500XAF),
  DSTV_PREMIUM_1_MONTH_28000XAF(
      "DSTV PREMIUM 01 MOIS - 28000 XAF",
      BigDecimal.valueOf(28000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[6]/div",
      PaymentType.SIMPAY_TO_DSTV_PREMIUM_1_MONTH_28000XAF),
  DSTV_CONFAM_SHOWMAX_1_MONTH_14500XAF(
      "DStv Comfam + Showmax 01 MOIS - 14500 XAF",
      BigDecimal.valueOf(14500),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[7]/div",
      PaymentType.SIMPAY_TO_DSTV_CONFAM_SHOWMAX_1_MONTH_14500XAF),
  DSTV_COMPACT_SHOWMAX_1_MONTH_24500XAF(
      "DStv Compact + Showmax 01 MOIS - 24500 XAF",
      BigDecimal.valueOf(24500),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[8]/div",
      PaymentType.SIMPAY_TO_DSTV_COMPACT_SHOWMAX_1_MONTH_24500XAF),
  DSTV_COMPACT_PLUS_SHOWMAX_1_MONTH_35000XAF(
      "DStv Compact Plus + Showmax 01 MOIS - 35000 XAF",
      BigDecimal.valueOf(35000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[9]/div",
      PaymentType.SIMPAY_TO_DSTV_COMPACT_PLUS_SHOWMAX_1_MONTH_35000XAF),
  DSTV_PREMIUM_WAFR_E36_SHOWMAX_1_MONTH_45000XAF(
      "DStv Premium W/Afr E36 + Showmax 01 MOIS - 45000 XAF",
      BigDecimal.valueOf(45000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[10]/div",
      PaymentType.SIMPAY_TO_DSTV_PREMIUM_WAFR_E36_SHOWMAX_1_MONTH_45000XAF),
  DSTV_PREMIUM_ASIA_1_MONTH_55000XAF(
      "DStv Premium Asia 01 Mois - 55000 XAF",
      BigDecimal.valueOf(55000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[11]/div",
      PaymentType.SIMPAY_TO_DSTV_PREMIUM_ASIA_1_MONTH_55000XAF);

  private final String bundleName;
  private final BigDecimal bundleAmount;
  private final String xPath;
  private final PaymentType paymentType;
}
