package com.simpay.processor.client.enums;

import java.math.BigDecimal;

import com.simpay.payment.client.enums.PaymentType;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum StartTimesBundleType {
  STARTIMES_SMART_5000XAF(
      "STARTIMES SMART 5000",
      BigDecimal.valueOf(5000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[1]/div",
      PaymentType.SIMPAY_TO_STARTIMES_SMART_5000XAF),
  STARTIMES_MAX_10500XAF(
      "STARTIMES MAX 10500",
      BigDecimal.valueOf(10500),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[2]/div",
      PaymentType.SIMPAY_TO_STARTIMES_MAX_10500XAF),
  STARTIMES_CHINOIS__13500XAF(
      "STARTIMES CHINOIS 13500",
      BigDecimal.valueOf(13500),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[3]/div",
      PaymentType.SIMPAY_TO_STARTIMES_CHINOIS__13500XAF),
  STARTIMES_SUPER_EN__9000XAF(
      "STARTIMES SUPER-EN 9000",
      BigDecimal.valueOf(9000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[4]/div",
      PaymentType.SIMPAY_TO_STARTIMES_SUPER_EN__9000XAF),
  STARTIMES_SUPER_FR__9000XAF(
      "STARTIMES SUPER-FR 9000",
      BigDecimal.valueOf(9000),
      "/html/body/div/div/div/div[2]/div/div/div[1]/div/div[3]/div[5]/div",
      PaymentType.SIMPAY_TO_STARTIMES_SUPER_FR__9000XAF);

  private final String bundleName;
  private final BigDecimal bundleAmount;
  private final String xPath;
  private final PaymentType paymentType;
}
