package com.simpay.processor.client.model;

import com.simpay.payment.client.enums.PaymentType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import lombok.*;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Schema(description = "Bundle type")
public class BundleType {
  @Schema(description = "Bundle key")
  private String key;

  @Schema(description = "Bundle labelle")
  private String labelle;

  @Schema(description = "Payment type")
  private PaymentType paymentType;

  @Schema(description = "Bundle amount")
  private BigDecimal amount;
}
