package com.simpay.processor.client.model.operation;


import com.simpay.processor.client.enums.CamtelBundleType;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.UUID;
import lombok.*;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Schema(description = "Camtel bill payment request")
public class CamtelBillPaymentRequest {
  @Schema(description = "User reference")
  @NotNull(message = "The user reference is required")
  private UUID userReference;

  @Schema(description = "Camtel bundle type")
  @NotNull(message = "The camtelBundleType is required")
  private CamtelBundleType camtelBundleType;

  @Schema(description = "recipient account number")
  @NotNull(message = "The recipientAccountNumber is required")
  private String recipientAccountNumber;
}
