package com.simpay.processor.client.model.operation;

import com.simpay.processor.client.enums.CanalPlusBundleType;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.UUID;
import lombok.*;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Schema(description = "Canal+ bill payment request")
public class CanalPlusBillPaymentRequest {
  @Schema(description = "User reference")
  @NotNull(message = "The user reference is required")
  private UUID userReference;

  @Schema(description = "Canal+ bundle type")
  @NotNull(message = "The Canal+ bundle type is required")
  private CanalPlusBundleType canalPlusBundleType;

  @Schema(description = "Decoder number")
  @NotNull(message = "The decoder number is required")
  private String decoderNumber;
}
